/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.userinterface.swing.generic.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.gradle.gradleplugin.foundation.GradlePluginLord;
import org.gradle.gradleplugin.foundation.favorites.FavoritesEditor;
import org.gradle.gradleplugin.foundation.settings.SettingsNode;
import org.gradle.gradleplugin.userinterface.swing.generic.Utility;
import org.gradle.gradleplugin.userinterface.swing.generic.tabs.GradleTab;

public class CommandLineTab
implements GradleTab {
    private GradlePluginLord gradlePluginLord;
    private FavoritesEditor favoritesEditor;
    private JPanel mainPanel;
    private JTextField commandLineField;
    private JButton executeButton;
    private JButton addToFavoritesButton;

    public CommandLineTab(GradlePluginLord gradlePluginLord, SettingsNode settingsNode) {
        this.gradlePluginLord = gradlePluginLord;
        this.favoritesEditor = gradlePluginLord.getFavoritesEditor();
    }

    public String getName() {
        return "Command Line";
    }

    public void aboutToShow() {
    }

    public Component createComponent() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add(this.createCommandLinePanel(), "North");
        mainPanel.add(Box.createVerticalGlue(), "Center");
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        return mainPanel;
    }

    private Component createCommandLinePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        this.commandLineField = new JTextField();
        this.commandLineField.registerKeyboardAction(new ExecuteAction(), KeyStroke.getKeyStroke(10, 0), 2);
        JPanel commandLinePanel = new JPanel();
        commandLinePanel.setLayout(new BoxLayout(commandLinePanel, 0));
        commandLinePanel.add(new JLabel("gradle "));
        commandLinePanel.add(this.commandLineField);
        panel.add(Utility.addLeftJustifiedComponent(new JLabel("Command Line:")));
        panel.add(Box.createVerticalStrut(5));
        panel.add(commandLinePanel);
        panel.add(Box.createVerticalStrut(5));
        panel.add(this.createButtonPanel());
        return panel;
    }

    private Component createButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.executeButton = new JButton(new ExecuteAction());
        this.addToFavoritesButton = new JButton(new AbstractAction("Add To Favorites"){

            public void actionPerformed(ActionEvent e) {
                CommandLineTab.this.addToFavorites();
            }
        });
        panel.add(Box.createHorizontalGlue());
        panel.add(this.executeButton);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(this.addToFavoritesButton);
        return panel;
    }

    private void addToFavorites() {
        String commandLineText = this.commandLineField.getText();
        this.favoritesEditor.addFavorite(commandLineText, false);
    }

    private void executeCommandLine() {
        String commandLineText = this.commandLineField.getText();
        this.gradlePluginLord.addExecutionRequestToQueue(commandLineText, "Command Line");
    }

    private class ExecuteAction
    extends AbstractAction {
        private ExecuteAction() {
            super("Execute");
        }

        public void actionPerformed(ActionEvent e) {
            CommandLineTab.this.executeCommandLine();
        }
    }
}

