/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.DefaultFileVisitDetails;
import org.gradle.api.internal.file.FileSystemSubset;
import org.gradle.api.internal.file.collections.DefaultDirectoryWalkerFactory;
import org.gradle.api.internal.file.collections.DirectoryTrees;
import org.gradle.api.internal.file.collections.DirectoryWalker;
import org.gradle.api.internal.file.collections.LocalFileTree;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.collections.PatternFilterableFileTree;
import org.gradle.api.internal.file.collections.RandomAccessFileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;
import org.gradle.internal.FileUtils;
import org.gradle.internal.nativeintegration.filesystem.Chmod;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.nativeintegration.filesystem.Stat;
import org.gradle.internal.nativeintegration.services.FileSystems;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryFileTree
implements MinimalFileTree,
PatternFilterableFileTree,
RandomAccessFileCollection,
LocalFileTree,
DirectoryTree {
    private static final Logger LOGGER = Logging.getLogger(DirectoryFileTree.class);
    private final File dir;
    private PatternSet patternSet;
    private boolean postfix;
    private final FileSystem fileSystem = FileSystems.getDefault();
    private static final Factory<DirectoryWalker> DEFAULT_DIRECTORY_WALKER_FACTORY = new DefaultDirectoryWalkerFactory();
    private final Factory<DirectoryWalker> directoryWalkerFactory;

    public DirectoryFileTree(File dir) {
        this(dir, new PatternSet());
    }

    public DirectoryFileTree(File dir, PatternSet patternSet) {
        this(dir, patternSet, DEFAULT_DIRECTORY_WALKER_FACTORY);
    }

    DirectoryFileTree(File dir, PatternSet patternSet, Factory<DirectoryWalker> directoryWalkerFactory) {
        this.patternSet = patternSet;
        this.dir = FileUtils.canonicalize((File)dir);
        this.directoryWalkerFactory = directoryWalkerFactory;
    }

    @Override
    public String getDisplayName() {
        String includes = this.patternSet.getIncludes().isEmpty() ? "" : String.format(" include %s", GUtil.toString(this.patternSet.getIncludes()));
        String excludes = this.patternSet.getExcludes().isEmpty() ? "" : String.format(" exclude %s", GUtil.toString(this.patternSet.getExcludes()));
        return String.format("directory '%s'%s%s", this.dir, includes, excludes);
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public PatternSet getPatterns() {
        return this.patternSet;
    }

    @Override
    public File getDir() {
        return this.dir;
    }

    @Override
    public Collection<DirectoryFileTree> getLocalContents() {
        return Collections.singletonList(this);
    }

    @Override
    public DirectoryFileTree filter(PatternFilterable patterns) {
        PatternSet patternSet = this.patternSet.intersect();
        patternSet.copyFrom(patterns);
        return new DirectoryFileTree(this.dir, patternSet, this.directoryWalkerFactory);
    }

    @Override
    public boolean contains(File file) {
        return DirectoryTrees.contains(this.fileSystem, this, file) && file.isFile();
    }

    @Override
    public void registerWatchPoints(FileSystemSubset.Builder builder) {
        builder.add(this);
    }

    @Override
    public void visitTreeOrBackingFile(FileVisitor visitor) {
        this.visit(visitor);
    }

    @Override
    public void visit(FileVisitor visitor) {
        this.visitFrom(visitor, this.dir, new RelativePath(false, new String[0]));
    }

    public void visitFrom(FileVisitor visitor, File fileOrDirectory, RelativePath path) {
        AtomicBoolean stopFlag = new AtomicBoolean();
        Spec<FileTreeElement> spec = this.patternSet.getAsSpec();
        if (fileOrDirectory.exists()) {
            if (fileOrDirectory.isFile()) {
                this.processSingleFile(fileOrDirectory, visitor, spec, stopFlag);
            } else {
                this.walkDir(fileOrDirectory, path, visitor, spec, stopFlag);
            }
        } else {
            LOGGER.info("file or directory '{}', not found", (Object)fileOrDirectory);
        }
    }

    private void processSingleFile(File file, FileVisitor visitor, Spec<FileTreeElement> spec, AtomicBoolean stopFlag) {
        RelativePath path = new RelativePath(true, file.getName());
        DefaultFileVisitDetails details = new DefaultFileVisitDetails(file, path, stopFlag, (Chmod)this.fileSystem, (Stat)this.fileSystem, false);
        if (DirectoryFileTree.isAllowed(details, spec)) {
            visitor.visitFile(details);
        }
    }

    private void walkDir(File file, RelativePath path, FileVisitor visitor, Spec<FileTreeElement> spec, AtomicBoolean stopFlag) {
        ((DirectoryWalker)this.directoryWalkerFactory.create()).walkDir(file, path, visitor, spec, stopFlag, this.postfix);
    }

    static boolean isAllowed(FileTreeElement element, Spec<FileTreeElement> spec) {
        return spec.isSatisfiedBy((Object)element);
    }

    public DirectoryFileTree postfix() {
        this.postfix = true;
        return this;
    }

    public PatternSet getPatternSet() {
        return this.patternSet;
    }
}

