/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization.loadercache;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gradle.api.internal.hash.Hasher;
import org.gradle.api.internal.initialization.loadercache.ClassPathSnapshot;
import org.gradle.api.internal.initialization.loadercache.ClassPathSnapshotter;
import org.gradle.internal.FileUtils;
import org.gradle.internal.classpath.ClassPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashClassPathSnapshotter
implements ClassPathSnapshotter {
    private final Hasher hasher;

    public HashClassPathSnapshotter(Hasher hasher) {
        this.hasher = hasher;
    }

    @Override
    public HashClassPathSnapshot snapshot(ClassPath classPath) {
        MessageDigest checksum;
        LinkedList visitedFilePaths = Lists.newLinkedList();
        LinkedHashSet visitedDirs = Sets.newLinkedHashSet();
        List cpFiles = classPath.getAsFiles();
        try {
            checksum = MessageDigest.getInstance("md5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.hash(checksum, visitedFilePaths, visitedDirs, cpFiles.iterator());
        return new HashClassPathSnapshot(visitedFilePaths, checksum.digest());
    }

    private void hash(MessageDigest combinedHash, List<String> visitedFilePaths, Set<File> visitedDirs, Iterator<File> toHash) {
        while (toHash.hasNext()) {
            File file = FileUtils.canonicalize((File)toHash.next());
            if (file.isDirectory()) {
                if (!visitedDirs.add(file)) continue;
                this.hash(combinedHash, visitedFilePaths, visitedDirs, (Iterator<File>)Iterators.forArray((Object[])file.listFiles()));
                continue;
            }
            if (!file.isFile()) continue;
            visitedFilePaths.add(file.getAbsolutePath());
            combinedHash.update(this.hasher.hash(file).asByteArray());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HashClassPathSnapshot
    implements ClassPathSnapshot {
        private final List<String> files;
        private final byte[] hash;

        public HashClassPathSnapshot(List<String> files, byte[] hash) {
            assert (files != null);
            this.files = files;
            this.hash = hash;
        }

        @Override
        public HashCode getStrongHash() {
            return HashCode.fromBytes((byte[])this.hash);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HashClassPathSnapshot that = (HashClassPathSnapshot)o;
            return Arrays.equals(this.hash, that.hash) && this.files.equals(that.files);
        }

        @Override
        public int hashCode() {
            int result = this.files.hashCode();
            result = 31 * result + Arrays.hashCode(this.hash);
            return result;
        }
    }
}

