/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publication.maven.internal;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.maven.MavenPom;
import org.gradle.api.internal.artifacts.publish.AbstractPublishArtifact;
import org.gradle.api.publication.maven.internal.ArtifactPom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultArtifactPom
implements ArtifactPom {
    private static final Set<String> PACKAGING_TYPES = Sets.newHashSet((Object[])new String[]{"war", "jar", "ear"});
    private final MavenPom pom;
    private final Map<ArtifactKey, PublishArtifact> artifacts = new HashMap<ArtifactKey, PublishArtifact>();
    private PublishArtifact artifact;
    private final Set<PublishArtifact> classifiers = new HashSet<PublishArtifact>();

    public DefaultArtifactPom(MavenPom pom) {
        this.pom = pom;
    }

    @Override
    public MavenPom getPom() {
        return this.pom;
    }

    @Override
    public PublishArtifact getArtifact() {
        return this.artifact;
    }

    @Override
    public Set<PublishArtifact> getAttachedArtifacts() {
        return Collections.unmodifiableSet(this.classifiers);
    }

    @Override
    public PublishArtifact writePom(File pomFile) {
        this.getPom().writeTo(pomFile);
        return new PomArtifact(pomFile);
    }

    @Override
    public void addArtifact(Artifact artifact, File src) {
        this.throwExceptionIfArtifactOrSrcIsNull(artifact, src);
        MavenArtifact publishArtifact = new MavenArtifact(artifact, src);
        ArtifactKey artifactKey = new ArtifactKey((PublishArtifact)publishArtifact);
        if (this.artifacts.containsKey(artifactKey)) {
            throw new InvalidUserDataException(String.format("A POM cannot have multiple artifacts with the same type and classifier. Already have %s, trying to add %s.", new Object[]{this.artifacts.get(artifactKey), publishArtifact}));
        }
        if (publishArtifact.getClassifier() != null) {
            this.addArtifact((PublishArtifact)publishArtifact);
            this.assignArtifactValuesToPom(artifact, this.pom, false);
            return;
        }
        if (this.artifact != null) {
            if (!PACKAGING_TYPES.contains(artifact.getType())) {
                this.addArtifact((PublishArtifact)publishArtifact);
                return;
            }
            if (PACKAGING_TYPES.contains(this.artifact.getType())) {
                throw new InvalidUserDataException("A POM can not have multiple main artifacts. Already have " + this.artifact + ", trying to add " + (Object)((Object)publishArtifact));
            }
            this.addArtifact(this.artifact);
        }
        this.artifact = publishArtifact;
        this.artifacts.put(artifactKey, (PublishArtifact)publishArtifact);
        this.assignArtifactValuesToPom(artifact, this.pom, true);
    }

    private void addArtifact(PublishArtifact artifact) {
        this.classifiers.add(artifact);
        this.artifacts.put(new ArtifactKey(artifact), artifact);
    }

    private String getClassifier(Artifact artifact) {
        return artifact.getExtraAttribute("classifier");
    }

    private void assignArtifactValuesToPom(Artifact artifact, MavenPom pom, boolean setType) {
        if (pom.getGroupId().equals("unknown")) {
            pom.setGroupId(artifact.getModuleRevisionId().getOrganisation());
        }
        if (pom.getArtifactId().equals("empty-project")) {
            pom.setArtifactId(artifact.getName());
        }
        if (pom.getVersion().equals("0")) {
            pom.setVersion(artifact.getModuleRevisionId().getRevision());
        }
        if (setType) {
            pom.setPackaging(artifact.getType());
        }
    }

    private void throwExceptionIfArtifactOrSrcIsNull(Artifact artifact, File src) {
        if (artifact == null) {
            throw new InvalidUserDataException("Artifact must not be null.");
        }
        if (src == null) {
            throw new InvalidUserDataException("Src file must not be null.");
        }
    }

    private class PomArtifact
    extends AbstractMavenArtifact {
        public PomArtifact(File pomFile) {
            super(pomFile);
        }

        public String getExtension() {
            return "pom";
        }

        public String getType() {
            return "pom";
        }

        public String getClassifier() {
            return null;
        }

        public Date getDate() {
            return null;
        }
    }

    private class MavenArtifact
    extends AbstractMavenArtifact {
        private final Artifact artifact;

        private MavenArtifact(Artifact artifact, File file) {
            super(file);
            this.artifact = artifact;
        }

        public String getClassifier() {
            return DefaultArtifactPom.this.getClassifier(this.artifact);
        }

        public String getExtension() {
            return this.artifact.getExt();
        }

        public String getType() {
            return this.artifact.getType();
        }
    }

    private abstract class AbstractMavenArtifact
    extends AbstractPublishArtifact {
        private final File file;

        protected AbstractMavenArtifact(File file) {
            super(new Object[0]);
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public String getName() {
            return DefaultArtifactPom.this.pom.getArtifactId();
        }

        public Date getDate() {
            return null;
        }
    }

    private static class ArtifactKey {
        private final String type;
        private final String classifier;

        private ArtifactKey(PublishArtifact artifact) {
            this.type = artifact.getType();
            this.classifier = artifact.getClassifier();
        }

        public boolean equals(Object o) {
            ArtifactKey other = (ArtifactKey)o;
            return ObjectUtils.equals((Object)this.type, (Object)other.type) && ObjectUtils.equals((Object)this.classifier, (Object)other.classifier);
        }

        public int hashCode() {
            return ObjectUtils.hashCode((Object)this.type) ^ ObjectUtils.hashCode((Object)this.classifier);
        }
    }
}

