/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.testing.testng;

import groovy.lang.Closure;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.xml.MarkupBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.JavaVersion;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.testing.TestFrameworkOptions;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.IoActions;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNGOptions
extends TestFrameworkOptions {
    private static final String JDK_ANNOTATIONS = "JDK";
    private static final String JAVADOC_ANNOTATIONS = "Javadoc";
    public static final String DEFAULT_CONFIG_FAILURE_POLICY = "skip";
    private File outputDirectory;
    private boolean javadocAnnotations;
    private List testResources;
    private Set<String> includeGroups = new HashSet<String>();
    private Set<String> excludeGroups = new HashSet<String>();
    private String configFailurePolicy = "skip";
    private Set<String> listeners = new LinkedHashSet<String>();
    private String parallel;
    private int threadCount = 1;
    private boolean useDefaultListeners;
    private String suiteName = "Gradle suite";
    private String testName = "Gradle test";
    private List<File> suiteXmlFiles = new ArrayList<File>();
    private boolean preserveOrder;
    private boolean groupByInstances;
    private transient StringWriter suiteXmlWriter;
    private transient MarkupBuilder suiteXmlBuilder;
    private final File projectDir;

    @Deprecated
    public String getAnnotations() {
        DeprecationLogger.nagUserOfDiscontinuedProperty((String)"TestNGOptions.annotations", (String)"Support for TestNG Javadoc annotations will be removed in Gradle 3.0.");
        return this.javadocAnnotations ? JAVADOC_ANNOTATIONS : JDK_ANNOTATIONS;
    }

    public TestNGOptions(File projectDir) {
        this.projectDir = projectDir;
    }

    @Deprecated
    public void setAnnotationsOnSourceCompatibility(JavaVersion sourceCompatibilityProp) {
        if (sourceCompatibilityProp.compareTo((Enum)JavaVersion.VERSION_1_5) >= 0) {
            this.jdkAnnotations();
        } else {
            this.javadocAnnotations();
        }
    }

    public MarkupBuilder suiteXmlBuilder() {
        this.suiteXmlWriter = new StringWriter();
        this.suiteXmlBuilder = new MarkupBuilder((Writer)this.suiteXmlWriter);
        return this.suiteXmlBuilder;
    }

    public void suites(String ... suiteFiles) {
        DefaultGroovyMethods.each((Object)suiteFiles, (Closure)new Closure<Boolean>((Object)this, (Object)this){

            public Boolean doCall(String it) {
                return TestNGOptions.this.suiteXmlFiles.add(new File(TestNGOptions.this.getProjectDir(), it));
            }

            public Boolean doCall() {
                return this.doCall(null);
            }
        });
    }

    protected File getProjectDir() {
        return this.projectDir;
    }

    public void suites(File ... suiteFiles) {
        this.suiteXmlFiles.addAll(Arrays.asList(suiteFiles));
    }

    public List<File> getSuites(File testSuitesDir) {
        ArrayList<File> suites = new ArrayList<File>();
        suites.addAll(this.suiteXmlFiles);
        if (this.suiteXmlBuilder != null) {
            File buildSuiteXml = new File(testSuitesDir.getAbsolutePath(), "build-suite.xml");
            if (buildSuiteXml.exists() && !buildSuiteXml.delete()) {
                throw new RuntimeException("failed to remove already existing build-suite.xml file");
            }
            IoActions.writeTextFile((File)buildSuiteXml, (Action)new ErroringAction<BufferedWriter>(){

                protected void doExecute(BufferedWriter writer) throws Exception {
                    writer.write("<!DOCTYPE suite SYSTEM \"http://testng.org/testng-1.0.dtd\">");
                    writer.newLine();
                    writer.write(TestNGOptions.this.suiteXmlWriter.toString());
                }
            });
            suites.add(buildSuiteXml);
        }
        return suites;
    }

    @Deprecated
    public TestNGOptions jdkAnnotations() {
        DeprecationLogger.nagUserOfDiscontinuedMethod((String)"TestNGOptions.jdkAnnotations()", (String)"Support for TestNG Javadoc annotations will be removed in Gradle 3.0.");
        this.javadocAnnotations = false;
        return this;
    }

    @Deprecated
    public TestNGOptions javadocAnnotations() {
        DeprecationLogger.nagUserOfDiscontinuedMethod((String)"TestNGOptions.javadocAnnotations()", (String)"Support for TestNG Javadoc annotations will be removed in Gradle 3.0.");
        this.javadocAnnotations = true;
        return this;
    }

    public TestNGOptions includeGroups(String ... includeGroups) {
        this.includeGroups.addAll(Arrays.asList(includeGroups));
        return this;
    }

    public TestNGOptions excludeGroups(String ... excludeGroups) {
        this.excludeGroups.addAll(Arrays.asList(excludeGroups));
        return this;
    }

    public TestNGOptions useDefaultListeners() {
        this.useDefaultListeners = true;
        return this;
    }

    public TestNGOptions useDefaultListeners(boolean useDefaultListeners) {
        this.useDefaultListeners = useDefaultListeners;
        return this;
    }

    public Object propertyMissing(String name) {
        if (this.suiteXmlBuilder != null) {
            return this.suiteXmlBuilder.getMetaClass().getProperty((Object)this.suiteXmlBuilder, name);
        }
        throw new MissingPropertyException(name, ((Object)((Object)this)).getClass());
    }

    public Object methodMissing(String name, Object args) {
        if (this.suiteXmlBuilder != null) {
            return this.suiteXmlBuilder.getMetaClass().invokeMethod((Object)this.suiteXmlBuilder, name, args);
        }
        throw new MissingMethodException(name, ((Object)((Object)this)).getClass(), (Object[])args);
    }

    @Deprecated
    public static String getJDK_ANNOTATIONS() {
        DeprecationLogger.nagUserOfDiscontinuedProperty((String)"TestNGOptions.JDK_ANNOTATIONS", (String)"Support for TestNG Javadoc annotations will be removed in Gradle 3.0.");
        return JDK_ANNOTATIONS;
    }

    @Deprecated
    public static String getJAVADOC_ANNOTATIONS() {
        DeprecationLogger.nagUserOfDiscontinuedProperty((String)"TestNGOptions.JAVADOC_ANNOTATIONS", (String)"Support for TestNG Javadoc annotations will be removed in Gradle 3.0.");
        return JAVADOC_ANNOTATIONS;
    }

    @Incubating
    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Incubating
    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Deprecated
    public boolean getJavadocAnnotations() {
        DeprecationLogger.nagUserOfDiscontinuedProperty((String)"TestNGOptions.javadocAnnotations", (String)"Support for TestNG Javadoc annotations will be removed in Gradle 3.0.");
        return this.javadocAnnotations;
    }

    @Deprecated
    public boolean isJavadocAnnotations() {
        DeprecationLogger.nagUserOfDiscontinuedProperty((String)"TestNGOptions.javadocAnnotations", (String)"Support for TestNG Javadoc annotations will be removed in Gradle 3.0.");
        return this.javadocAnnotations;
    }

    @Deprecated
    public void setJavadocAnnotations(boolean javadocAnnotations) {
        DeprecationLogger.nagUserOfDiscontinuedProperty((String)"TestNGOptions.javadocAnnotations", (String)"Support for TestNG Javadoc annotations will be removed in Gradle 3.0.");
        this.javadocAnnotations = javadocAnnotations;
    }

    @Deprecated
    public List getTestResources() {
        DeprecationLogger.nagUserOfDiscontinuedProperty((String)"TestNGOptions.testResources", (String)"Support for TestNG Javadoc annotations will be removed in Gradle 3.0.");
        return this.testResources;
    }

    @Deprecated
    public void setTestResources(List testResources) {
        DeprecationLogger.nagUserOfDiscontinuedProperty((String)"TestNGOptions.testResources", (String)"Support for TestNG Javadoc annotations will be removed in Gradle 3.0.");
        this.testResources = testResources;
    }

    public Set<String> getIncludeGroups() {
        return this.includeGroups;
    }

    public void setIncludeGroups(Set<String> includeGroups) {
        this.includeGroups = includeGroups;
    }

    public Set<String> getExcludeGroups() {
        return this.excludeGroups;
    }

    public void setExcludeGroups(Set<String> excludeGroups) {
        this.excludeGroups = excludeGroups;
    }

    public String getConfigFailurePolicy() {
        return this.configFailurePolicy;
    }

    public void setConfigFailurePolicy(String configFailurePolicy) {
        this.configFailurePolicy = configFailurePolicy;
    }

    public Set<String> getListeners() {
        return this.listeners;
    }

    public void setListeners(Set<String> listeners) {
        this.listeners = listeners;
    }

    public String getParallel() {
        return this.parallel;
    }

    public void setParallel(String parallel) {
        this.parallel = parallel;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public boolean getUseDefaultListeners() {
        return this.useDefaultListeners;
    }

    public boolean isUseDefaultListeners() {
        return this.useDefaultListeners;
    }

    public void setUseDefaultListeners(boolean useDefaultListeners) {
        this.useDefaultListeners = useDefaultListeners;
    }

    public String getSuiteName() {
        return this.suiteName;
    }

    public void setSuiteName(String suiteName) {
        this.suiteName = suiteName;
    }

    public String getTestName() {
        return this.testName;
    }

    public void setTestName(String testName) {
        this.testName = testName;
    }

    public List<File> getSuiteXmlFiles() {
        return this.suiteXmlFiles;
    }

    public void setSuiteXmlFiles(List<File> suiteXmlFiles) {
        this.suiteXmlFiles = suiteXmlFiles;
    }

    public boolean getPreserveOrder() {
        return this.preserveOrder;
    }

    @Incubating
    public boolean isPreserveOrder() {
        return this.preserveOrder;
    }

    @Incubating
    public void setPreserveOrder(boolean preserveOrder) {
        this.preserveOrder = preserveOrder;
    }

    @Incubating
    public boolean getGroupByInstances() {
        return this.groupByInstances;
    }

    @Incubating
    public boolean isGroupByInstances() {
        return this.groupByInstances;
    }

    @Incubating
    public void setGroupByInstances(boolean groupByInstances) {
        this.groupByInstances = groupByInstances;
    }

    public StringWriter getSuiteXmlWriter() {
        return this.suiteXmlWriter;
    }

    public void setSuiteXmlWriter(StringWriter suiteXmlWriter) {
        this.suiteXmlWriter = suiteXmlWriter;
    }

    public MarkupBuilder getSuiteXmlBuilder() {
        return this.suiteXmlBuilder;
    }

    public void setSuiteXmlBuilder(MarkupBuilder suiteXmlBuilder) {
        this.suiteXmlBuilder = suiteXmlBuilder;
    }
}

