/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.analyzer;

import java.io.File;
import org.gradle.api.internal.hash.Hasher;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassAnalysisCache;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassDependenciesAnalyzer;
import org.gradle.internal.Factory;
import org.gradle.internal.hash.HashValue;

public class CachingClassDependenciesAnalyzer
implements ClassDependenciesAnalyzer {
    private final ClassDependenciesAnalyzer analyzer;
    private final Hasher hasher;
    private final ClassAnalysisCache cache;

    public CachingClassDependenciesAnalyzer(ClassDependenciesAnalyzer analyzer, Hasher hasher, ClassAnalysisCache cache) {
        this.analyzer = analyzer;
        this.hasher = hasher;
        this.cache = cache;
    }

    public ClassAnalysis getClassAnalysis(final String className, final File classFile) {
        HashValue hash = this.hasher.hash(classFile);
        return (ClassAnalysis)this.cache.get(hash, (Factory)new Factory<ClassAnalysis>(){

            public ClassAnalysis create() {
                return CachingClassDependenciesAnalyzer.this.analyzer.getClassAnalysis(className, classFile);
            }
        });
    }
}

