/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.jar;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarArchive;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshotData;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotter;
import org.gradle.internal.hash.HashValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarClasspathSnapshotFactory {
    private final JarSnapshotter jarSnapshotter;

    public JarClasspathSnapshotFactory(JarSnapshotter jarSnapshotter) {
        this.jarSnapshotter = jarSnapshotter;
    }

    JarClasspathSnapshot createSnapshot(Iterable<JarArchive> jarArchives) {
        HashMap<File, JarSnapshot> jarSnapshots = new HashMap<File, JarSnapshot>();
        HashMap<File, HashValue> jarHashes = new HashMap<File, HashValue>();
        HashSet<String> allClasses = new HashSet<String>();
        HashSet<String> duplicateClasses = new HashSet<String>();
        for (JarArchive jar : jarArchives) {
            JarSnapshot snapshot = this.jarSnapshotter.createSnapshot(jar);
            jarSnapshots.put(jar.file, snapshot);
            jarHashes.put(jar.file, snapshot.getHash());
            for (String c : snapshot.getClasses()) {
                if (allClasses.add(c)) continue;
                duplicateClasses.add(c);
            }
        }
        JarClasspathSnapshotData jarClasspathSnapshotData = new JarClasspathSnapshotData(jarHashes, duplicateClasses);
        return new JarClasspathSnapshot(jarSnapshots, jarClasspathSnapshotData);
    }
}

