/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.cache;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gradle.api.Nullable;
import org.gradle.internal.Cast;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.cache.WeakClassSet;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelSchemaCache {
    private final HashMap<WeakClassSet, Map<ModelType<?>, ModelSchema<?>>> cache = Maps.newHashMap();

    @Nullable
    public <T> ModelSchema<T> get(ModelType<T> type) {
        Map<ModelType<?>, ModelSchema<?>> typeCache = this.cache.get(WeakClassSet.of(type));
        if (typeCache == null) {
            return null;
        }
        return (ModelSchema)Cast.uncheckedCast(typeCache.get(type));
    }

    public <T> void set(ModelType<T> type, ModelSchema<T> schema) {
        WeakClassSet cacheKey = WeakClassSet.of(type);
        HashMap typeCache = this.cache.get(cacheKey);
        if (typeCache == null) {
            typeCache = Maps.newHashMap();
            this.cache.put(cacheKey, typeCache);
        }
        typeCache.put(type, schema);
    }

    public long size() {
        this.cleanUp();
        long size = 0L;
        for (Map<ModelType<?>, ModelSchema<?>> values : this.cache.values()) {
            size += (long)values.size();
        }
        return size;
    }

    public void cleanUp() {
        Iterator<Map.Entry<WeakClassSet, Map<ModelType<?>, ModelSchema<?>>>> iterator = this.cache.entrySet().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getKey().isCollected()) continue;
            iterator.remove();
        }
    }
}

