/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal.resolve;

import java.io.File;
import java.util.Set;
import org.gradle.api.Buildable;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.nativeplatform.HeaderExportingSourceSet;
import org.gradle.nativeplatform.NativeDependencySet;
import org.gradle.nativeplatform.internal.resolve.NativeBinaryRequirementResolveResult;
import org.gradle.nativeplatform.internal.resolve.NativeBinaryResolveResult;
import org.gradle.nativeplatform.internal.resolve.NativeDependencyResolver;

public class SourceSetNativeDependencyResolver
implements NativeDependencyResolver {
    private final NativeDependencyResolver delegate;
    private final FileCollectionFactory fileCollectionFactory;

    public SourceSetNativeDependencyResolver(NativeDependencyResolver delegate, FileCollectionFactory fileCollectionFactory) {
        this.delegate = delegate;
        this.fileCollectionFactory = fileCollectionFactory;
    }

    public void resolve(NativeBinaryResolveResult nativeBinaryResolveResult) {
        for (NativeBinaryRequirementResolveResult resolution : nativeBinaryResolveResult.getPendingResolutions()) {
            if (!(resolution.getInput() instanceof LanguageSourceSet)) continue;
            LanguageSourceSet input = (LanguageSourceSet)resolution.getInput();
            resolution.setNativeDependencySet(this.createNativeDependencySet(input));
        }
        this.delegate.resolve(nativeBinaryResolveResult);
    }

    private NativeDependencySet createNativeDependencySet(LanguageSourceSet sourceSet) {
        if (sourceSet instanceof HeaderExportingSourceSet) {
            return new LanguageSourceSetNativeDependencySet((HeaderExportingSourceSet)sourceSet, this.fileCollectionFactory);
        }
        return new EmptyNativeDependencySet();
    }

    private static class LanguageSourceSetNativeDependencySet
    extends EmptyNativeDependencySet {
        private final HeaderExportingSourceSet sourceSet;
        private final FileCollectionFactory fileCollectionFactory;

        private LanguageSourceSetNativeDependencySet(HeaderExportingSourceSet sourceSet, FileCollectionFactory fileCollectionFactory) {
            this.sourceSet = sourceSet;
            this.fileCollectionFactory = fileCollectionFactory;
        }

        public FileCollection getIncludeRoots() {
            return this.fileCollectionFactory.create((MinimalFileSet)new HeaderFileCollection());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class HeaderFileCollection
        implements MinimalFileSet,
        Buildable {
            private HeaderFileCollection() {
            }

            public String getDisplayName() {
                return "Include roots of " + LanguageSourceSetNativeDependencySet.this.sourceSet.getName();
            }

            public Set<File> getFiles() {
                return LanguageSourceSetNativeDependencySet.this.sourceSet.getExportedHeaders().getSrcDirs();
            }

            public TaskDependency getBuildDependencies() {
                return LanguageSourceSetNativeDependencySet.this.sourceSet.getBuildDependencies();
            }
        }
    }

    private static class EmptyNativeDependencySet
    implements NativeDependencySet {
        private EmptyNativeDependencySet() {
        }

        public FileCollection getIncludeRoots() {
            return this.empty();
        }

        public FileCollection getLinkFiles() {
            return this.empty();
        }

        public FileCollection getRuntimeFiles() {
            return this.empty();
        }

        private FileCollection empty() {
            return new SimpleFileCollection(new File[0]);
        }
    }
}

