/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.platform.internal;

import org.gradle.nativeplatform.platform.internal.ArchitectureInternal;
import org.gradle.nativeplatform.platform.internal.Architectures;

public class DefaultArchitecture
implements ArchitectureInternal {
    private final String name;

    public DefaultArchitecture(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return "architecture '" + this.name + "'";
    }

    public boolean isI386() {
        return Architectures.X86.isAlias(this.name);
    }

    public boolean isAmd64() {
        return Architectures.X86_64.isAlias(this.name);
    }

    public boolean isIa64() {
        return Architectures.IA_64.isAlias(this.name);
    }

    public boolean isArm() {
        return Architectures.ARM_V7.isAlias(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultArchitecture other = (DefaultArchitecture)o;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

