/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.platform.internal;

import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.nativeplatform.platform.internal.ArchitectureInternal;
import org.gradle.nativeplatform.platform.internal.Architectures;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.platform.internal.DefaultOperatingSystem;
import org.gradle.nativeplatform.platform.internal.OperatingSystemInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativePlatforms {
    private static final String OS_WINDOWS = "windows";
    private static final String OS_LINUX = "linux";
    private static final String OS_OSX = "osx";
    private static final String OS_UNIX = "unix";
    private static final String ARCH_X86 = "x86";

    public Set<DefaultNativePlatform> defaultPlatformDefinitions() {
        LinkedHashSet<DefaultNativePlatform> platforms = new LinkedHashSet<DefaultNativePlatform>();
        DefaultOperatingSystem windows = new DefaultOperatingSystem(OS_WINDOWS);
        DefaultOperatingSystem linux = new DefaultOperatingSystem(OS_LINUX);
        DefaultOperatingSystem osx = new DefaultOperatingSystem(OS_OSX);
        DefaultOperatingSystem unix = new DefaultOperatingSystem(OS_UNIX);
        DefaultOperatingSystem freebsd = new DefaultOperatingSystem("freebsd");
        DefaultOperatingSystem solaris = new DefaultOperatingSystem("solaris");
        ArchitectureInternal x86 = Architectures.forInput(ARCH_X86);
        ArchitectureInternal x64 = Architectures.forInput("x86_64");
        ArchitectureInternal ia64 = Architectures.forInput("ia64");
        ArchitectureInternal armv7 = Architectures.forInput("armv7");
        ArchitectureInternal armv8 = Architectures.forInput("armv8");
        ArchitectureInternal sparc = Architectures.forInput("sparc");
        ArchitectureInternal ultrasparc = Architectures.forInput("ultrasparc");
        ArchitectureInternal ppc = Architectures.forInput("ppc");
        ArchitectureInternal ppc64 = Architectures.forInput("ppc64");
        platforms.add(NativePlatforms.createPlatform(windows, x86));
        platforms.add(NativePlatforms.createPlatform(windows, x64));
        platforms.add(NativePlatforms.createPlatform(windows, armv7));
        platforms.add(NativePlatforms.createPlatform(windows, ia64));
        platforms.add(NativePlatforms.createPlatform(freebsd, x86));
        platforms.add(NativePlatforms.createPlatform(freebsd, x64));
        platforms.add(NativePlatforms.createPlatform(freebsd, armv7));
        platforms.add(NativePlatforms.createPlatform(freebsd, armv8));
        platforms.add(NativePlatforms.createPlatform(freebsd, ppc));
        platforms.add(NativePlatforms.createPlatform(freebsd, ppc64));
        platforms.add(NativePlatforms.createPlatform(unix, x86));
        platforms.add(NativePlatforms.createPlatform(unix, x64));
        platforms.add(NativePlatforms.createPlatform(unix, armv7));
        platforms.add(NativePlatforms.createPlatform(unix, armv8));
        platforms.add(NativePlatforms.createPlatform(unix, ppc));
        platforms.add(NativePlatforms.createPlatform(unix, ppc64));
        platforms.add(NativePlatforms.createPlatform(linux, x64));
        platforms.add(NativePlatforms.createPlatform(linux, x86));
        platforms.add(NativePlatforms.createPlatform(linux, armv7));
        platforms.add(NativePlatforms.createPlatform(linux, armv8));
        platforms.add(NativePlatforms.createPlatform(osx, x86));
        platforms.add(NativePlatforms.createPlatform(osx, x64));
        platforms.add(NativePlatforms.createPlatform(solaris, x64));
        platforms.add(NativePlatforms.createPlatform(solaris, x86));
        platforms.add(NativePlatforms.createPlatform(solaris, sparc));
        platforms.add(NativePlatforms.createPlatform(solaris, ultrasparc));
        return platforms;
    }

    private static DefaultNativePlatform createPlatform(OperatingSystemInternal os, ArchitectureInternal arch) {
        return new DefaultNativePlatform(NativePlatforms.platformName(os.getName(), arch.getName()), os, arch);
    }

    private static String platformName(String os, String arch) {
        return os + "_" + arch;
    }

    public String getDefaultPlatformName() {
        DefaultNativePlatform defaultPlatform = new DefaultNativePlatform("default");
        OperatingSystemInternal os = defaultPlatform.getOperatingSystem();
        ArchitectureInternal architecture = defaultPlatform.getArchitecture();
        if (os.isWindows()) {
            return NativePlatforms.platformName(OS_WINDOWS, ARCH_X86);
        }
        if (os.isLinux()) {
            return NativePlatforms.platformName(OS_LINUX, architecture.getName());
        }
        if (os.isMacOsX()) {
            return NativePlatforms.platformName(OS_OSX, architecture.getName());
        }
        return NativePlatforms.platformName(OS_UNIX, ARCH_X86);
    }
}

