/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.building;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.maven.model.building.ModelSource2;

public class FileModelSource
implements ModelSource2 {
    private final File pomFile;

    public FileModelSource(File pomFile) {
        if (pomFile == null) {
            throw new IllegalArgumentException("no POM file specified");
        }
        this.pomFile = pomFile.getAbsoluteFile();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.pomFile);
    }

    @Override
    public String getLocation() {
        return this.pomFile.getPath();
    }

    public File getPomFile() {
        return this.pomFile;
    }

    public String toString() {
        return this.getLocation();
    }

    @Override
    public ModelSource2 getRelatedSource(String relPath) {
        relPath = relPath.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        File relatedPom = new File(this.pomFile.getParentFile(), relPath);
        if (relatedPom.isDirectory()) {
            relatedPom = new File(relatedPom, "pom.xml");
        }
        if (relatedPom.isFile() && relatedPom.canRead()) {
            return new FileModelSource(new File(relatedPom.toURI().normalize()));
        }
        return null;
    }

    @Override
    public URI getLocationURI() {
        return this.pomFile.toURI();
    }
}

