/*
 * Decompiled with CFR 0.152.
 */
package org.grails.gsp;

import grails.util.Environment;
import groovy.lang.Binding;
import groovy.lang.Writable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.gsp.GroovyPage;
import org.grails.gsp.GroovyPageBinding;
import org.grails.gsp.GroovyPageMetaInfo;
import org.grails.gsp.GroovyPagesException;
import org.grails.taglib.AbstractTemplateVariableBinding;
import org.grails.taglib.TemplateVariableBinding;
import org.grails.taglib.encoder.OutputContext;
import org.grails.taglib.encoder.OutputContextLookup;

public class GroovyPageWritable
implements Writable {
    private static final Log LOG = LogFactory.getLog(GroovyPageWritable.class);
    private static final String GSP_NONE_CODEC_NAME = "none";
    private GroovyPageMetaInfo metaInfo;
    private OutputContextLookup outputContextLookup;
    private boolean allowSettingContentType;
    private Map additionalBinding = new LinkedHashMap();
    private boolean showSource;
    private static final String GROOVY_SOURCE_CONTENT_TYPE = "text/plain";
    private static final GspNoneCodec gspNoneCodeInstance = new GspNoneCodec();

    public GroovyPageWritable(GroovyPageMetaInfo metaInfo, OutputContextLookup outputContextLookup, boolean allowSettingContentType) {
        this.metaInfo = metaInfo;
        this.outputContextLookup = outputContextLookup;
        this.allowSettingContentType = allowSettingContentType;
    }

    public void setBinding(Map binding) {
        if (binding != null) {
            this.additionalBinding = binding;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writer writeTo(Writer out) throws IOException {
        OutputContext outputContext = this.outputContextLookup.lookupOutputContext();
        try {
            Writer writer = this.doWriteTo(outputContext, out);
            return writer;
        }
        finally {
            this.doCleanUp(outputContext, out);
        }
    }

    protected void doCleanUp(OutputContext outputContext, Writer out) {
        this.metaInfo.writeToFinished(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Writer doWriteTo(OutputContext outputContext, Writer out) throws IOException {
        if (this.shouldShowGroovySource(outputContext)) {
            outputContext.setContentType(GROOVY_SOURCE_CONTENT_TYPE);
            this.writeGroovySourceToResponse(this.metaInfo, out);
        } else {
            boolean contentTypeAlreadySet;
            boolean debugTemplates = this.shouldDebugTemplates(outputContext);
            if (this.metaInfo.getCompilationException() != null) {
                throw this.metaInfo.getCompilationException();
            }
            AbstractTemplateVariableBinding parentBinding = null;
            boolean hasRequest = outputContext != null;
            boolean newParentCreated = false;
            if (hasRequest && (parentBinding = outputContext.getBinding()) == null && outputContext != null) {
                parentBinding = outputContext.createAndRegisterRootBinding();
                newParentCreated = true;
            }
            if (this.allowSettingContentType && hasRequest && !(contentTypeAlreadySet = outputContext.isContentTypeAlreadySet())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Writing output with content type: " + this.metaInfo.getContentType()));
                }
                outputContext.setContentType(this.metaInfo.getContentType());
            }
            GroovyPageBinding binding = this.createBinding((Binding)parentBinding);
            if (hasRequest) {
                outputContext.setBinding((AbstractTemplateVariableBinding)binding);
            }
            GroovyPage page = null;
            try {
                page = (GroovyPage)((Object)this.metaInfo.getPageClass().newInstance());
            }
            catch (Exception e) {
                throw new GroovyPagesException("Problem instantiating page class", e);
            }
            page.setBinding((Binding)binding);
            binding.setOwner((Object)page);
            page.initRun(out, outputContext, this.metaInfo);
            int debugId = 0;
            long debugStartTimeMs = 0L;
            if (debugTemplates) {
                debugId = this.incrementAndGetDebugTemplatesIdCounter(outputContext);
                out.write("<!-- GSP #");
                out.write(String.valueOf(debugId));
                out.write(" START template: ");
                out.write(page.getGroovyPageFileName());
                out.write(" precompiled: ");
                out.write(String.valueOf(this.metaInfo.isPrecompiledMode()));
                out.write(" lastmodified: ");
                out.write(DateFormat.getDateTimeInstance(3, 3).format(new Date(this.metaInfo.getLastModified())));
                out.write(" -->");
                debugStartTimeMs = System.currentTimeMillis();
            }
            try {
                page.run();
            }
            finally {
                page.cleanup();
                if (hasRequest) {
                    if (newParentCreated) {
                        outputContext.setBinding(null);
                    } else {
                        outputContext.setBinding(parentBinding);
                    }
                }
            }
            if (debugTemplates) {
                out.write("<!-- GSP #");
                out.write(String.valueOf(debugId));
                out.write(" END template: ");
                out.write(page.getGroovyPageFileName());
                out.write(" rendering time: ");
                out.write(String.valueOf(System.currentTimeMillis() - debugStartTimeMs));
                out.write(" ms -->");
            }
        }
        return out;
    }

    private int incrementAndGetDebugTemplatesIdCounter(OutputContext outputContext) {
        return 0;
    }

    private boolean shouldDebugTemplates(OutputContext outputContext) {
        return false;
    }

    private boolean shouldShowGroovySource(OutputContext outputContext) {
        return this.isShowSource() && Environment.getCurrent() == Environment.DEVELOPMENT && this.metaInfo.getGroovySource() != null;
    }

    public boolean isShowSource() {
        return this.showSource;
    }

    public void setShowSource(boolean showSource) {
        this.showSource = showSource;
    }

    private GroovyPageBinding createBinding(Binding parent) {
        GroovyPageBinding binding = new GroovyPageBinding();
        binding.setParent(parent);
        binding.setVariableDirectly("it", null);
        if (this.additionalBinding != null) {
            binding.addMap(this.additionalBinding);
        }
        if (parent == null || parent instanceof TemplateVariableBinding && ((TemplateVariableBinding)parent).isRoot() || "".equals(this.metaInfo.getPluginPath())) {
            binding.setPluginContextPath(this.metaInfo.getPluginPath());
        }
        binding.setPagePlugin(this.metaInfo.getPagePlugin());
        return binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeInputStreamToResponse(InputStream in, Writer out) throws IOException {
        try {
            int read;
            in.reset();
            InputStreamReader reader = new InputStreamReader(in, "UTF-8");
            char[] buf = new char[8192];
            while ((read = reader.read(buf)) > 0) {
                out.write(buf, 0, read);
            }
        }
        finally {
            out.close();
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeGroovySourceToResponse(GroovyPageMetaInfo info, Writer out) throws IOException {
        InputStream in = info.getGroovySource();
        if (in == null) {
            return;
        }
        try {
            try {
                in.reset();
            }
            catch (IOException e) {
                // empty catch block
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            int lineNum = 1;
            int maxPaddingSize = 3;
            StringBuilder paddingBuffer = new StringBuilder(maxPaddingSize);
            for (int i = 0; i < maxPaddingSize; ++i) {
                paddingBuffer.append(' ');
            }
            String padding = paddingBuffer.toString();
            String line = reader.readLine();
            while (line != null) {
                String numberText = String.valueOf(lineNum);
                if (padding.length() + numberText.length() > 4) {
                    paddingBuffer.deleteCharAt(padding.length() - 1);
                    padding = paddingBuffer.toString();
                }
                out.write(padding);
                out.write(numberText);
                out.write(": ");
                out.write(line);
                out.write(10);
                line = reader.readLine();
                ++lineNum;
            }
        }
        finally {
            out.close();
            in.close();
        }
    }

    private static final class GspNoneCodec {
        private GspNoneCodec() {
        }

        public final Object encode(Object object) {
            return object;
        }
    }
}

