/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.adapter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.gradle.internal.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompatibleIntrospector {
    private final Object target;

    public CompatibleIntrospector(Object target) {
        this.target = target;
    }

    private Method getMethod(String methodName) throws NoSuchMethodException {
        Method[] methods;
        for (Method m : methods = this.target.getClass().getDeclaredMethods()) {
            if (!m.getName().equals(methodName)) continue;
            return m;
        }
        throw new NoSuchMethodException("No such method: '" + methodName + "' on type: '" + this.target.getClass().getSimpleName() + "'.");
    }

    public <T> T getSafely(T defaultValue, String methodName) {
        try {
            Method method = this.getMethod(methodName);
            method.setAccessible(true);
            return (T)method.invoke(this.target, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return defaultValue;
        }
        catch (InvocationTargetException e) {
            throw UncheckedException.throwAsUncheckedException(e.getCause());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get value reflectively", e);
        }
    }

    public void callSafely(String methodName, Object ... params) {
        Method method;
        try {
            method = this.getMethod(methodName);
        }
        catch (NoSuchMethodException e) {
            return;
        }
        method.setAccessible(true);
        try {
            method.invoke(this.target, params);
        }
        catch (InvocationTargetException e) {
            throw UncheckedException.throwAsUncheckedException(e.getCause());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to call method reflectively", e);
        }
    }
}

