/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import org.gradle.api.JavaVersion;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.DefaultExecutorFactory;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.jvm.UnsupportedJavaRuntimeException;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.connection.GradleConnectionBuilder;
import org.gradle.tooling.internal.connection.DefaultGradleConnectionBuilder;
import org.gradle.tooling.internal.connection.GradleConnectionFactory;
import org.gradle.tooling.internal.consumer.ConnectionFactory;
import org.gradle.tooling.internal.consumer.DefaultCancellationTokenSource;
import org.gradle.tooling.internal.consumer.DefaultExecutorServiceFactory;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.gradle.tooling.internal.consumer.DistributionFactory;
import org.gradle.tooling.internal.consumer.ExecutorServiceFactory;
import org.gradle.tooling.internal.consumer.LoggingProvider;
import org.gradle.tooling.internal.consumer.SynchronizedLogging;
import org.gradle.tooling.internal.consumer.loader.CachingToolingImplementationLoader;
import org.gradle.tooling.internal.consumer.loader.DefaultToolingImplementationLoader;
import org.gradle.tooling.internal.consumer.loader.SynchronizedToolingImplementationLoader;
import org.gradle.tooling.internal.consumer.loader.ToolingImplementationLoader;

public class ConnectorServices {
    private static DefaultServiceRegistry singletonRegistry = new ConnectorServiceRegistry();

    public static DefaultGradleConnector createConnector() {
        ConnectorServices.assertJava6();
        return singletonRegistry.getFactory(DefaultGradleConnector.class).create();
    }

    public static GradleConnectionBuilder createGradleConnectionBuilder() {
        ConnectorServices.assertJava6();
        return singletonRegistry.getFactory(GradleConnectionBuilder.class).create();
    }

    public static CancellationTokenSource createCancellationTokenSource() {
        ConnectorServices.assertJava6();
        return new DefaultCancellationTokenSource();
    }

    public static void close() {
        ConnectorServices.assertJava6();
        singletonRegistry.close();
    }

    public static void reset() {
        singletonRegistry.close();
        singletonRegistry = new ConnectorServiceRegistry();
    }

    private static void assertJava6() {
        JavaVersion javaVersion = JavaVersion.current();
        if (!javaVersion.isJava6Compatible()) {
            throw UnsupportedJavaRuntimeException.usingUnsupportedVersion("Gradle Tooling API", JavaVersion.VERSION_1_6);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConnectorServiceRegistry
    extends DefaultServiceRegistry {
        private ConnectorServiceRegistry() {
        }

        protected Factory<DefaultGradleConnector> createConnectorFactory(final ConnectionFactory connectionFactory, final DistributionFactory distributionFactory) {
            return new Factory<DefaultGradleConnector>(){

                @Override
                public DefaultGradleConnector create() {
                    return new DefaultGradleConnector(connectionFactory, distributionFactory);
                }
            };
        }

        protected Factory<GradleConnectionBuilder> createGradleConnectionBuilder(final GradleConnectionFactory gradleConnectionFactory, final DistributionFactory distributionFactory) {
            return new Factory<GradleConnectionBuilder>(){

                @Override
                public GradleConnectionBuilder create() {
                    return new DefaultGradleConnectionBuilder(gradleConnectionFactory, distributionFactory);
                }
            };
        }

        protected ExecutorFactory createExecutorFactory() {
            return new DefaultExecutorFactory();
        }

        protected ExecutorServiceFactory createExecutorServiceFactory() {
            return new DefaultExecutorServiceFactory();
        }

        protected DistributionFactory createDistributionFactory(ExecutorServiceFactory executorFactory) {
            return new DistributionFactory(executorFactory);
        }

        protected ToolingImplementationLoader createToolingImplementationLoader() {
            return new SynchronizedToolingImplementationLoader(new CachingToolingImplementationLoader(new DefaultToolingImplementationLoader()));
        }

        protected LoggingProvider createLoggingProvider() {
            return new SynchronizedLogging();
        }

        protected ConnectionFactory createConnectionFactory(ToolingImplementationLoader toolingImplementationLoader, ExecutorFactory executorFactory, LoggingProvider loggingProvider) {
            return new ConnectionFactory(toolingImplementationLoader, executorFactory, loggingProvider);
        }

        protected GradleConnectionFactory createGradleConnectionFactory(ToolingImplementationLoader toolingImplementationLoader, ExecutorFactory executorFactory, LoggingProvider loggingProvider) {
            return new GradleConnectionFactory(toolingImplementationLoader, executorFactory, loggingProvider);
        }
    }
}

