/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.transaction;

import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.test.context.TestContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.TransactionManagementConfigurer;
import org.springframework.transaction.interceptor.DelegatingTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class TestContextTransactionUtils {
    private static final Log logger = LogFactory.getLog(TestContextTransactionUtils.class);
    public static final String DEFAULT_DATA_SOURCE_NAME = "dataSource";
    public static final String DEFAULT_TRANSACTION_MANAGER_NAME = "transactionManager";

    private TestContextTransactionUtils() {
    }

    public static DataSource retrieveDataSource(TestContext testContext, String name) {
        Assert.notNull((Object)testContext, (String)"TestContext must not be null");
        AutowireCapableBeanFactory bf = testContext.getApplicationContext().getAutowireCapableBeanFactory();
        try {
            if (StringUtils.hasText((String)name)) {
                return (DataSource)bf.getBean(name, DataSource.class);
            }
        }
        catch (BeansException ex) {
            logger.error((Object)String.format("Failed to retrieve DataSource named '%s' for test context %s", name, testContext), (Throwable)ex);
            throw ex;
        }
        try {
            ListableBeanFactory lbf;
            Map dataSources;
            if (bf instanceof ListableBeanFactory && (dataSources = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)(lbf = (ListableBeanFactory)bf), DataSource.class)).size() == 1) {
                return (DataSource)dataSources.values().iterator().next();
            }
            return (DataSource)bf.getBean(DEFAULT_DATA_SOURCE_NAME, DataSource.class);
        }
        catch (BeansException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Caught exception while retrieving DataSource for test context " + testContext), (Throwable)ex);
            }
            return null;
        }
    }

    public static PlatformTransactionManager retrieveTransactionManager(TestContext testContext, String name) {
        Assert.notNull((Object)testContext, (String)"TestContext must not be null");
        AutowireCapableBeanFactory bf = testContext.getApplicationContext().getAutowireCapableBeanFactory();
        try {
            if (StringUtils.hasText((String)name)) {
                return (PlatformTransactionManager)bf.getBean(name, PlatformTransactionManager.class);
            }
        }
        catch (BeansException ex) {
            logger.error((Object)String.format("Failed to retrieve transaction manager named '%s' for test context %s", name, testContext), (Throwable)ex);
            throw ex;
        }
        try {
            if (bf instanceof ListableBeanFactory) {
                ListableBeanFactory lbf = (ListableBeanFactory)bf;
                Map txMgrs = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)lbf, PlatformTransactionManager.class);
                if (txMgrs.size() == 1) {
                    return (PlatformTransactionManager)txMgrs.values().iterator().next();
                }
                Map configurers = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)lbf, TransactionManagementConfigurer.class);
                if (configurers.size() > 1) {
                    throw new IllegalStateException("Only one TransactionManagementConfigurer may exist in the ApplicationContext");
                }
                if (configurers.size() == 1) {
                    return ((TransactionManagementConfigurer)configurers.values().iterator().next()).annotationDrivenTransactionManager();
                }
            }
            return (PlatformTransactionManager)bf.getBean(DEFAULT_TRANSACTION_MANAGER_NAME, PlatformTransactionManager.class);
        }
        catch (BeansException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Caught exception while retrieving transaction manager for test context " + testContext), (Throwable)ex);
            }
            return null;
        }
    }

    public static TransactionAttribute createDelegatingTransactionAttribute(TestContext testContext, TransactionAttribute targetAttribute) {
        Assert.notNull((Object)testContext, (String)"TestContext must not be null");
        Assert.notNull((Object)targetAttribute, (String)"Target TransactionAttribute must not be null");
        return new TestContextTransactionAttribute(targetAttribute, testContext);
    }

    private static class TestContextTransactionAttribute
    extends DelegatingTransactionAttribute {
        private final String name;

        public TestContextTransactionAttribute(TransactionAttribute targetAttribute, TestContext testContext) {
            super(targetAttribute);
            this.name = testContext.getTestClass().getName() + "." + testContext.getTestMethod().getName();
        }

        public String getName() {
            return this.name;
        }
    }
}

