/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded.ri;

import java.util.List;
import org.springsource.loaded.ri.Invoker;
import org.springsource.loaded.ri.MethodProvider;

public class GetDeclaredMethodLookup {
    private String name;
    private String paramsDescriptor;

    public GetDeclaredMethodLookup(String name, String paramsDescriptor) {
        this.name = name;
        this.paramsDescriptor = paramsDescriptor;
    }

    public Invoker lookup(MethodProvider methodProvider) {
        List<Invoker> methods = methodProvider.getDeclaredMethods();
        Invoker found = null;
        for (Invoker invoker : methods) {
            if (!this.matches(invoker) || found != null && !this.isMoreSpecificReturnTypeThan(invoker, found)) continue;
            found = invoker;
        }
        return found;
    }

    private boolean isMoreSpecificReturnTypeThan(Invoker m1, Invoker m2) {
        Class<?> cls1 = m1.getReturnType();
        Class<?> cls2 = m2.getReturnType();
        return cls2.isAssignableFrom(cls1);
    }

    protected boolean matches(Invoker invoker) {
        return this.name.equals(invoker.getName()) && this.paramsDescriptor.equals(invoker.getParamsDescriptor());
    }

    public String toString() {
        return "GetDeclaredMethod( " + this.name + "." + this.paramsDescriptor + " )";
    }
}

