/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.Transport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchCommand
extends TransportCommand<FetchCommand, FetchResult> {
    private String remote = "origin";
    private List<RefSpec> refSpecs;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private boolean checkFetchedObjects;
    private Boolean removeDeletedRefs;
    private boolean dryRun;
    private boolean thin = true;
    private TagOpt tagOption;

    protected FetchCommand(Repository repo) {
        super(repo);
        this.refSpecs = new ArrayList<RefSpec>(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FetchResult call() throws GitAPIException, InvalidRemoteException, TransportException {
        this.checkCallable();
        Transport transport = Transport.open(this.repo, this.remote);
        try {
            FetchResult result;
            transport.setCheckFetchedObjects(this.checkFetchedObjects);
            transport.setRemoveDeletedRefs(this.isRemoveDeletedRefs());
            transport.setDryRun(this.dryRun);
            if (this.tagOption != null) {
                transport.setTagOpt(this.tagOption);
            }
            transport.setFetchThin(this.thin);
            this.configure(transport);
            FetchResult fetchResult = result = transport.fetch(this.monitor, this.refSpecs);
            transport.close();
            return fetchResult;
        }
        catch (Throwable throwable) {
            try {
                transport.close();
                throw throwable;
            }
            catch (NoRemoteRepositoryException e) {
                throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidRemote, this.remote), e);
            }
            catch (org.eclipse.jgit.errors.TransportException e) {
                throw new TransportException(e.getMessage(), e);
            }
            catch (URISyntaxException e) {
                throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidRemote, this.remote));
            }
            catch (NotSupportedException e) {
                throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfFetchCommand, e);
            }
        }
    }

    public FetchCommand setRemote(String remote) {
        this.checkCallable();
        this.remote = remote;
        return this;
    }

    public String getRemote() {
        return this.remote;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isCheckFetchedObjects() {
        return this.checkFetchedObjects;
    }

    public FetchCommand setCheckFetchedObjects(boolean checkFetchedObjects) {
        this.checkCallable();
        this.checkFetchedObjects = checkFetchedObjects;
        return this;
    }

    public boolean isRemoveDeletedRefs() {
        if (this.removeDeletedRefs != null) {
            return this.removeDeletedRefs;
        }
        boolean result = false;
        StoredConfig config = this.repo.getConfig();
        result = config.getBoolean("fetch", null, "prune", result);
        result = config.getBoolean("remote", this.remote, "prune", result);
        return result;
    }

    public FetchCommand setRemoveDeletedRefs(boolean removeDeletedRefs) {
        this.checkCallable();
        this.removeDeletedRefs = removeDeletedRefs;
        return this;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public FetchCommand setProgressMonitor(ProgressMonitor monitor) {
        this.checkCallable();
        this.monitor = monitor;
        return this;
    }

    public List<RefSpec> getRefSpecs() {
        return this.refSpecs;
    }

    public FetchCommand setRefSpecs(RefSpec ... specs) {
        this.checkCallable();
        this.refSpecs.clear();
        for (RefSpec spec : specs) {
            this.refSpecs.add(spec);
        }
        return this;
    }

    public FetchCommand setRefSpecs(List<RefSpec> specs) {
        this.checkCallable();
        this.refSpecs.clear();
        this.refSpecs.addAll(specs);
        return this;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public FetchCommand setDryRun(boolean dryRun) {
        this.checkCallable();
        this.dryRun = dryRun;
        return this;
    }

    public boolean isThin() {
        return this.thin;
    }

    public FetchCommand setThin(boolean thin) {
        this.checkCallable();
        this.thin = thin;
        return this;
    }

    public FetchCommand setTagOpt(TagOpt tagOpt) {
        this.checkCallable();
        this.tagOption = tagOpt;
        return this;
    }
}

