/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import java.io.IOException;
import org.apache.xerces.impl.validation.XMLGrammarPoolImpl;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSDeclarationPool;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.parsers.StandardParserConfiguration;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.SynchronizedSymbolTable;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLInputSource;

public class XMLGrammarCachingConfiguration
extends StandardParserConfiguration {
    public static final int BIG_PRIME = 2039;
    protected static final SynchronizedSymbolTable fStaticSymbolTable = new SynchronizedSymbolTable(2039);
    protected static final XMLGrammarPoolImpl fStaticGrammarPool = new XMLGrammarPoolImpl();
    protected static final String SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    String XMLNS = this.fSymbolTable.addSymbol("xmlns");
    String URI_XSI = this.fSymbolTable.addSymbol("http://www.w3.org/2001/XMLSchema-instance");
    String XSI_SCHEMALOCATION = this.fSymbolTable.addSymbol("schemaLocation");
    String XSI_NONAMESPACESCHEMALOCATION = this.fSymbolTable.addSymbol("noNamespaceSchemaLocation");
    String XSI_TYPE = this.fSymbolTable.addSymbol("type");
    String XSI_NIL = this.fSymbolTable.addSymbol("nil");
    String URI_SCHEMAFORSCHEMA = this.fSymbolTable.addSymbol("http://www.w3.org/2001/XMLSchema");
    protected XSDHandler fSchemaHandler;
    protected XSGrammarBucket fXSGrammarBucket;
    protected SubstitutionGroupHandler fSubGroupHandler;
    protected CMBuilder fCMBuilder;

    public XMLGrammarCachingConfiguration() {
        this(fStaticSymbolTable, fStaticGrammarPool, null);
    }

    public XMLGrammarCachingConfiguration(SymbolTable symbolTable) {
        this(symbolTable, fStaticGrammarPool, null);
    }

    public XMLGrammarCachingConfiguration(SymbolTable symbolTable, XMLGrammarPool xMLGrammarPool) {
        this(symbolTable, xMLGrammarPool, null);
    }

    public XMLGrammarCachingConfiguration(SymbolTable symbolTable, XMLGrammarPool xMLGrammarPool, XMLComponentManager xMLComponentManager) {
        super(symbolTable, xMLGrammarPool, xMLComponentManager);
    }

    public boolean lockGrammarPool() {
        return this.fGrammarPool instanceof XMLGrammarPoolImpl;
    }

    public Grammar parseGrammar(String string, String string2) throws XNIException, IOException {
        XMLInputSource xMLInputSource = new XMLInputSource(null, string2, null);
        return this.parseGrammar(string, xMLInputSource);
    }

    public Grammar parseGrammar(String string, XMLInputSource xMLInputSource) throws XNIException, IOException {
        if (!string.equals("XSD")) {
            return null;
        }
        if (this.fSchemaHandler == null) {
            this.fXSGrammarBucket = new XSGrammarBucket();
            this.fSubGroupHandler = new SubstitutionGroupHandler(this.fXSGrammarBucket);
            this.fSchemaHandler = new XSDHandler(this.fXSGrammarBucket);
            this.fCMBuilder = new CMBuilder(new XSDeclarationPool());
        }
        String string2 = (String)this.getProperty("http://apache.org/xml/properties/schema/external-schemaLocation");
        String string3 = (String)this.getProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation");
        this.fXSGrammarBucket.reset();
        SchemaGrammar[] schemaGrammarArray = (SchemaGrammar[])this.fGrammarPool.retrieveInitialGrammarSet("XSD");
        int n = 0;
        while (n < schemaGrammarArray.length) {
            this.fXSGrammarBucket.putGrammar(schemaGrammarArray[n]);
            ++n;
        }
        this.fSubGroupHandler.reset();
        this.fSchemaHandler.reset(this.fErrorReporter, this.fEntityManager, this.fSymbolTable, string2, string3, this.fGrammarPool);
        SchemaGrammar schemaGrammar = this.fSchemaHandler.parseSchema(null, xMLInputSource, (short)3);
        if (this.getFeature(SCHEMA_FULL_CHECKING)) {
            XSConstraints.fullSchemaChecking(this.fXSGrammarBucket, this.fSubGroupHandler, this.fCMBuilder, this.fErrorReporter);
        }
        this.fGrammarPool.cacheGrammars("XSD", new Grammar[]{schemaGrammar});
        return schemaGrammar;
    }

    protected void checkFeature(String string) throws XMLConfigurationException {
        super.checkFeature(string);
    }

    protected void checkProperty(String string) throws XMLConfigurationException {
        super.checkProperty(string);
    }
}

