/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.regions;

import jadx.core.dex.attributes.AType;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IBranchRegion;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.AbstractRegion;
import jadx.core.dex.regions.Region;
import jadx.core.dex.regions.TryCatchRegion;
import jadx.core.dex.regions.loops.LoopRegion;
import jadx.core.dex.trycatch.CatchAttr;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.trycatch.SplitterBlockAttr;
import jadx.core.dex.trycatch.TryCatchBlock;
import jadx.core.dex.visitors.regions.AbstractRegionVisitor;
import jadx.core.dex.visitors.regions.DepthRegionTraversal;
import jadx.core.dex.visitors.regions.IRegionIterativeVisitor;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.ErrorsCounter;
import jadx.core.utils.RegionUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessTryCatchRegions
extends AbstractRegionVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessTryCatchRegions.class);

    public static void process(MethodNode mth) {
        if (mth.isNoCode() || mth.isNoExceptionHandlers()) {
            return;
        }
        final HashMap<BlockNode, TryCatchBlock> tryBlocksMap = new HashMap<BlockNode, TryCatchBlock>(2);
        ProcessTryCatchRegions.searchTryCatchDominators(mth, tryBlocksMap);
        IRegionIterativeVisitor visitor = new IRegionIterativeVisitor(){

            @Override
            public boolean visitRegion(MethodNode mth, IRegion region) {
                boolean changed = ProcessTryCatchRegions.checkAndWrap(mth, tryBlocksMap, region);
                return changed && !tryBlocksMap.isEmpty();
            }
        };
        DepthRegionTraversal.traverseIncludingExcHandlers(mth, visitor);
    }

    private static void searchTryCatchDominators(MethodNode mth, Map<BlockNode, TryCatchBlock> tryBlocksMap) {
        HashSet<TryCatchBlock> tryBlocks = new HashSet<TryCatchBlock>();
        for (BlockNode block : mth.getBasicBlocks()) {
            CatchAttr c = block.get(AType.CATCH_BLOCK);
            if (c == null) continue;
            tryBlocks.add(c.getTryBlock());
        }
        for (TryCatchBlock tb : tryBlocks) {
            TryCatchBlock prevTB;
            BlockNode domBlock;
            if (tb.getHandlersCount() == 0) {
                LOG.warn("No exception handlers in catch block, method: {}", (Object)mth);
                continue;
            }
            BitSet bs = new BitSet(mth.getBasicBlocks().size());
            for (ExceptionHandler excHandler : tb.getHandlers()) {
                SplitterBlockAttr splitter = excHandler.getHandlerBlock().get(AType.SPLITTER_BLOCK);
                if (splitter == null) continue;
                BlockNode block = splitter.getBlock();
                bs.set(block.getId());
            }
            List<BlockNode> domBlocks = BlockUtils.bitSetToBlocks(mth, bs);
            if (domBlocks.size() != 1) {
                domBlock = BlockUtils.getTopBlock(domBlocks);
                if (domBlock == null) {
                    throw new JadxRuntimeException("Exception block dominator not found, method:" + mth + ". bs: " + domBlocks);
                }
            } else {
                domBlock = domBlocks.get(0);
            }
            if ((prevTB = tryBlocksMap.put(domBlock, tb)) == null) continue;
            ErrorsCounter.methodError(mth, "Failed to process nested try/catch");
        }
    }

    private static boolean checkAndWrap(MethodNode mth, Map<BlockNode, TryCatchBlock> tryBlocksMap, IRegion region) {
        for (Map.Entry<BlockNode, TryCatchBlock> entry : tryBlocksMap.entrySet()) {
            BlockNode dominator = entry.getKey();
            if (!region.getSubBlocks().contains(dominator)) continue;
            TryCatchBlock tb = tryBlocksMap.get(dominator);
            if (!ProcessTryCatchRegions.wrapBlocks(region, tb, dominator)) {
                ErrorsCounter.methodError(mth, "Can't wrap try/catch for " + region);
            }
            tryBlocksMap.remove(dominator);
            return true;
        }
        return false;
    }

    private static boolean wrapBlocks(IRegion replaceRegion, TryCatchBlock tb, BlockNode dominator) {
        if (replaceRegion == null) {
            return false;
        }
        if (replaceRegion instanceof LoopRegion) {
            LoopRegion loop = (LoopRegion)replaceRegion;
            return ProcessTryCatchRegions.wrapBlocks(loop.getBody(), tb, dominator);
        }
        if (replaceRegion instanceof IBranchRegion) {
            return ProcessTryCatchRegions.wrapBlocks(replaceRegion.getParent(), tb, dominator);
        }
        Region tryRegion = new Region(replaceRegion);
        List<IContainer> subBlocks = replaceRegion.getSubBlocks();
        for (IContainer cont : subBlocks) {
            if (!RegionUtils.hasPathThroughBlock(dominator, cont)) continue;
            if (ProcessTryCatchRegions.isHandlerPath(tb, cont)) break;
            tryRegion.getSubBlocks().add(cont);
        }
        if (tryRegion.getSubBlocks().isEmpty()) {
            return false;
        }
        TryCatchRegion tryCatchRegion = new TryCatchRegion(replaceRegion, tryRegion);
        tryRegion.setParent(tryCatchRegion);
        tryCatchRegion.setTryCatchBlock(tb.getCatchAttr().getTryBlock());
        IContainer firstNode = tryRegion.getSubBlocks().get(0);
        if (!replaceRegion.replaceSubBlock(firstNode, tryCatchRegion)) {
            return false;
        }
        subBlocks.removeAll(tryRegion.getSubBlocks());
        for (IContainer cont : tryRegion.getSubBlocks()) {
            if (!(cont instanceof AbstractRegion)) continue;
            AbstractRegion aReg = (AbstractRegion)cont;
            aReg.setParent(tryRegion);
        }
        return true;
    }

    private static boolean isHandlerPath(TryCatchBlock tb, IContainer cont) {
        for (ExceptionHandler h : tb.getHandlers()) {
            if (!RegionUtils.hasPathThroughBlock(h.getHandlerBlock(), cont)) continue;
            return true;
        }
        return false;
    }
}

