/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import org.fife.ui.rsyntaxtextarea.RtfToText;

class RtfTransferable
implements Transferable {
    private byte[] data;
    private final DataFlavor[] FLAVORS = new DataFlavor[]{new DataFlavor("text/rtf", "RTF"), DataFlavor.stringFlavor, DataFlavor.plainTextFlavor};

    public RtfTransferable(byte[] data) {
        this.data = data;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(this.FLAVORS[0])) {
            return new ByteArrayInputStream(this.data == null ? new byte[]{} : this.data);
        }
        if (flavor.equals(this.FLAVORS[1])) {
            return this.data == null ? "" : RtfToText.getPlainText(this.data);
        }
        if (flavor.equals(this.FLAVORS[2])) {
            String text = "";
            if (this.data != null) {
                text = RtfToText.getPlainText(this.data);
            }
            return new StringReader(text);
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])this.FLAVORS.clone();
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (int i = 0; i < this.FLAVORS.length; ++i) {
            if (!flavor.equals(this.FLAVORS[i])) continue;
            return true;
        }
        return false;
    }
}

