/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.svg;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.value.AbstractValueManager;
import org.apache.batik.css.engine.value.StringValue;
import org.apache.batik.css.engine.value.URIValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.svg.SVGValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class ColorProfileManager
extends AbstractValueManager {
    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public String getPropertyName() {
        return "color-profile";
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 20;
    }

    @Override
    public Value getDefaultValue() {
        return SVGValueConstants.AUTO_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 12: {
                return SVGValueConstants.INHERIT_VALUE;
            }
            case 35: {
                String string = lexicalUnit.getStringValue().toLowerCase();
                if (string.equals("auto")) {
                    return SVGValueConstants.AUTO_VALUE;
                }
                if (string.equals("srgb")) {
                    return SVGValueConstants.SRGB_VALUE;
                }
                return new StringValue(21, string);
            }
            case 24: {
                return new URIValue(lexicalUnit.getStringValue(), ColorProfileManager.resolveURI(cSSEngine.getCSSBaseURI(), lexicalUnit.getStringValue()));
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
    }

    @Override
    public Value createStringValue(short s, String string, CSSEngine cSSEngine) throws DOMException {
        switch (s) {
            case 21: {
                String string2 = string.toLowerCase();
                if (string2.equals("auto")) {
                    return SVGValueConstants.AUTO_VALUE;
                }
                if (string2.equals("srgb")) {
                    return SVGValueConstants.SRGB_VALUE;
                }
                return new StringValue(21, string2);
            }
            case 20: {
                return new URIValue(string, ColorProfileManager.resolveURI(cSSEngine.getCSSBaseURI(), string));
            }
        }
        throw this.createInvalidStringTypeDOMException(s);
    }
}

