/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.svg;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.value.AbstractValueManager;
import org.apache.batik.css.engine.value.FloatValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.svg.SVGValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public abstract class GlyphOrientationManager
extends AbstractValueManager {
    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return false;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 5;
    }

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 12: {
                return SVGValueConstants.INHERIT_VALUE;
            }
            case 28: {
                return new FloatValue(11, lexicalUnit.getFloatValue());
            }
            case 29: {
                return new FloatValue(13, lexicalUnit.getFloatValue());
            }
            case 30: {
                return new FloatValue(12, lexicalUnit.getFloatValue());
            }
            case 13: {
                int n = lexicalUnit.getIntegerValue();
                return new FloatValue(11, n);
            }
            case 14: {
                float f = lexicalUnit.getFloatValue();
                return new FloatValue(11, f);
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
    }

    @Override
    public Value createFloatValue(short s, float f) throws DOMException {
        switch (s) {
            case 11: 
            case 12: 
            case 13: {
                return new FloatValue(s, f);
            }
        }
        throw this.createInvalidFloatValueDOMException(f);
    }
}

