/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.xinclude;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import org.apache.xerces.util.XMLStringBuffer;
import org.apache.xerces.xinclude.XIncludeHandler;
import org.apache.xerces.xni.parser.XMLInputSource;

public class XIncludeTextReader {
    private Reader fReader;
    private XIncludeHandler fHandler;
    private XMLInputSource fSource;
    private boolean fCheckBOM = false;

    public XIncludeTextReader(XMLInputSource xMLInputSource, XIncludeHandler xIncludeHandler) throws IOException {
        this.fHandler = xIncludeHandler;
        this.fSource = xMLInputSource;
    }

    protected Reader getReader(XMLInputSource xMLInputSource) throws IOException {
        if (xMLInputSource.getCharacterStream() != null) {
            this.fReader = xMLInputSource.getCharacterStream();
            return this.fReader;
        }
        InputStream inputStream = null;
        String string = xMLInputSource.getEncoding();
        if (string == null) {
            string = "UTF-8";
        }
        if (xMLInputSource.getByteStream() != null) {
            inputStream = xMLInputSource.getByteStream();
        } else {
            URL uRL = new URL(new URL(xMLInputSource.getBaseSystemId()), xMLInputSource.getSystemId());
            inputStream = uRL.openStream();
            URLConnection uRLConnection = uRL.openConnection();
            String string2 = uRLConnection.getContentEncoding();
            String string3 = uRLConnection.getContentType();
            if (string2 != null) {
                string = string2;
            } else if (string3.equals("text/xml")) {
                string = "US-ASCII";
            } else if (string3.equals("application/xml")) {
                string = this.getEncodingName(inputStream);
            } else if (string3.endsWith("+xml")) {
                System.out.println("Not suppported");
            }
        }
        this.fReader = new InputStreamReader(inputStream, string);
        return this.fReader;
    }

    protected String getEncodingName(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        int n = 0;
        inputStream.mark(4);
        while (n < 4) {
            byArray[n] = (byte)inputStream.read();
            ++n;
        }
        Object[] objectArray = this.getEncodingName(byArray, n);
        if (objectArray[1] != null && !((Boolean)objectArray[1]).booleanValue()) {
            inputStream.reset();
            this.fCheckBOM = false;
        } else {
            this.fCheckBOM = true;
        }
        return (String)objectArray[0];
    }

    protected Object[] getEncodingName(byte[] byArray, int n) {
        if (n < 2) {
            return new Object[]{"UTF-8", new Boolean(false)};
        }
        int n2 = byArray[0] & 0xFF;
        int n3 = byArray[1] & 0xFF;
        if (n2 == 254 && n3 == 255) {
            return new Object[]{"UTF-16BE", new Boolean(true)};
        }
        if (n2 == 255 && n3 == 254) {
            return new Object[]{"UTF-16LE", new Boolean(true)};
        }
        if (n < 3) {
            return new Object[]{"UTF-8", new Boolean(false)};
        }
        int n4 = byArray[2] & 0xFF;
        if (n2 == 239 && n3 == 187 && n4 == 191) {
            return new Object[]{"UTF-8", new Boolean(true)};
        }
        if (n < 4) {
            return new Object[]{"UTF-8", new Boolean(false)};
        }
        int n5 = byArray[3] & 0xFF;
        if (n2 == 0 && n3 == 0 && n4 == 0 && n5 == 60) {
            return new Object[]{"ISO-10646-UCS-4", new Boolean(true)};
        }
        if (n2 == 60 && n3 == 0 && n4 == 0 && n5 == 0) {
            return new Object[]{"ISO-10646-UCS-4", new Boolean(true)};
        }
        if (n2 == 0 && n3 == 0 && n4 == 60 && n5 == 0) {
            return new Object[]{"ISO-10646-UCS-4", new Boolean(true)};
        }
        if (n2 == 0 && n3 == 60 && n4 == 0 && n5 == 0) {
            return new Object[]{"ISO-10646-UCS-4", new Boolean(true)};
        }
        if (n2 == 0 && n3 == 60 && n4 == 0 && n5 == 63) {
            return new Object[]{"UTF-16BE", new Boolean(false)};
        }
        if (n2 == 60 && n3 == 0 && n4 == 63 && n5 == 0) {
            return new Object[]{"UTF-16LE", new Boolean(false)};
        }
        if (n2 == 76 && n3 == 111 && n4 == 167 && n5 == 148) {
            return new Object[]{"CP037", new Boolean(false)};
        }
        if (n2 == 0 && n3 == 0 && n4 == 0 && n5 == 60) {
            return new Object[]{"UCS-4", new Boolean(false)};
        }
        return new Object[]{"UTF-8", new Boolean(false)};
    }

    public void parse() throws IOException {
        XMLStringBuffer xMLStringBuffer = new XMLStringBuffer();
        this.fReader = this.getReader(this.fSource);
        if (this.fReader.ready()) {
            int n;
            if (!this.fCheckBOM && (n = this.fReader.read()) != 65279) {
                xMLStringBuffer.append((char)n);
            }
            while (this.fReader.ready()) {
                xMLStringBuffer.append((char)this.fReader.read());
            }
            if (this.fHandler != null) {
                this.fHandler.characters(xMLStringBuffer, this.fHandler.modifyAugmentations(null, true));
            }
        }
    }

    public void close() throws IOException {
        if (this.fReader != null) {
            this.fReader.close();
        }
    }
}

