/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Shape;
import java.awt.geom.PathIterator;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphicObjectConverter;
import org.w3c.dom.Element;

public class SVGPath
extends SVGGraphicObjectConverter {
    public SVGPath(SVGGeneratorContext sVGGeneratorContext) {
        super(sVGGeneratorContext);
    }

    public Element toSVG(Shape shape) {
        String string = SVGPath.toSVGPathData(shape, this.generatorContext);
        if (string == null || string.length() == 0) {
            return null;
        }
        Element element = this.generatorContext.domFactory.createElementNS("http://www.w3.org/2000/svg", "path");
        element.setAttributeNS(null, "d", string);
        if (shape.getPathIterator(null).getWindingRule() == 0) {
            element.setAttributeNS(null, "fill-rule", "evenodd");
        }
        return element;
    }

    public static String toSVGPathData(Shape shape, SVGGeneratorContext sVGGeneratorContext) {
        StringBuffer stringBuffer = new StringBuffer(40);
        PathIterator pathIterator = shape.getPathIterator(null);
        float[] fArray = new float[6];
        int n = 0;
        while (!pathIterator.isDone()) {
            n = pathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    stringBuffer.append("M");
                    SVGPath.appendPoint(stringBuffer, fArray[0], fArray[1], sVGGeneratorContext);
                    break;
                }
                case 1: {
                    stringBuffer.append("L");
                    SVGPath.appendPoint(stringBuffer, fArray[0], fArray[1], sVGGeneratorContext);
                    break;
                }
                case 4: {
                    stringBuffer.append("Z");
                    break;
                }
                case 2: {
                    stringBuffer.append("Q");
                    SVGPath.appendPoint(stringBuffer, fArray[0], fArray[1], sVGGeneratorContext);
                    SVGPath.appendPoint(stringBuffer, fArray[2], fArray[3], sVGGeneratorContext);
                    break;
                }
                case 3: {
                    stringBuffer.append("C");
                    SVGPath.appendPoint(stringBuffer, fArray[0], fArray[1], sVGGeneratorContext);
                    SVGPath.appendPoint(stringBuffer, fArray[2], fArray[3], sVGGeneratorContext);
                    SVGPath.appendPoint(stringBuffer, fArray[4], fArray[5], sVGGeneratorContext);
                    break;
                }
                default: {
                    throw new Error("invalid segmentType:" + n);
                }
            }
            pathIterator.next();
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString().trim();
        }
        return "";
    }

    private static void appendPoint(StringBuffer stringBuffer, float f, float f2, SVGGeneratorContext sVGGeneratorContext) {
        stringBuffer.append(sVGGeneratorContext.doubleString(f));
        stringBuffer.append(" ");
        stringBuffer.append(sVGGeneratorContext.doubleString(f2));
        stringBuffer.append(" ");
    }
}

