/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CIDSubset {
    private Map<Integer, Integer> usedGlyphs = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> usedGlyphsIndex = new HashMap<Integer, Integer>();
    private int usedGlyphsCount = 0;
    private Map<Integer, Character> usedCharsIndex = new HashMap<Integer, Character>();

    public void setupFirstGlyph() {
        this.usedGlyphs.put(0, 0);
        this.usedGlyphsIndex.put(0, 0);
        ++this.usedGlyphsCount;
    }

    public int getGlyphIndexForSubsetIndex(int subsetIndex) {
        Integer glyphIndex = this.usedGlyphsIndex.get(subsetIndex);
        if (glyphIndex != null) {
            return glyphIndex;
        }
        return -1;
    }

    public char getUnicodeForSubsetIndex(int subsetIndex) {
        Character mapValue = this.usedCharsIndex.get(subsetIndex);
        if (mapValue != null) {
            return mapValue.charValue();
        }
        return '\uffff';
    }

    public int mapSubsetChar(int glyphIndex, char unicode) {
        Integer subsetCharSelector = this.usedGlyphs.get(glyphIndex);
        if (subsetCharSelector == null) {
            int selector = this.usedGlyphsCount++;
            this.usedGlyphs.put(glyphIndex, selector);
            this.usedGlyphsIndex.put(selector, glyphIndex);
            this.usedCharsIndex.put(selector, Character.valueOf(unicode));
            return selector;
        }
        return subsetCharSelector;
    }

    public Map<Integer, Integer> getSubsetGlyphs() {
        return Collections.unmodifiableMap(this.usedGlyphs);
    }

    public char[] getSubsetChars() {
        char[] charArray = new char[this.usedGlyphsCount];
        for (int i = 0; i < this.usedGlyphsCount; ++i) {
            charArray[i] = this.getUnicodeForSubsetIndex(i);
        }
        return charArray;
    }

    public int getSubsetSize() {
        return this.usedGlyphsCount;
    }

    public BitSet getGlyphIndexBitSet() {
        BitSet bitset = new BitSet();
        for (Integer cid : this.usedGlyphs.keySet()) {
            bitset.set(cid);
        }
        return bitset;
    }
}

