/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.EncodingMode;
import org.apache.fop.fonts.FontTriplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbedFontInfo
implements Serializable {
    private static final long serialVersionUID = 8755432068669997369L;
    protected String metricsFile;
    protected String embedFile;
    protected boolean kerning;
    protected boolean advanced;
    protected EncodingMode encodingMode = EncodingMode.AUTO;
    protected EmbeddingMode embeddingMode = EmbeddingMode.AUTO;
    protected String postScriptName = null;
    protected String subFontName = null;
    private List<FontTriplet> fontTriplets = null;
    private transient boolean embedded = true;

    public EmbedFontInfo(String metricsFile, boolean kerning, boolean advanced, List<FontTriplet> fontTriplets, String embedFile, String subFontName) {
        this.metricsFile = metricsFile;
        this.embedFile = embedFile;
        this.kerning = kerning;
        this.advanced = advanced;
        this.fontTriplets = fontTriplets;
        this.subFontName = subFontName;
    }

    public String getMetricsFile() {
        return this.metricsFile;
    }

    public String getEmbedFile() {
        return this.embedFile;
    }

    public boolean getKerning() {
        return this.kerning;
    }

    public boolean getAdvanced() {
        return this.advanced;
    }

    public String getSubFontName() {
        return this.subFontName;
    }

    public String getPostScriptName() {
        return this.postScriptName;
    }

    public void setPostScriptName(String postScriptName) {
        this.postScriptName = postScriptName;
    }

    public List<FontTriplet> getFontTriplets() {
        return this.fontTriplets;
    }

    public boolean isEmbedded() {
        if (this.metricsFile != null && this.embedFile == null) {
            return false;
        }
        return this.embedded;
    }

    public EmbeddingMode getEmbeddingMode() {
        return this.embeddingMode;
    }

    public void setEmbedded(boolean value) {
        this.embedded = value;
    }

    public EncodingMode getEncodingMode() {
        return this.encodingMode;
    }

    public void setEncodingMode(EncodingMode mode) {
        if (mode == null) {
            throw new NullPointerException("mode must not be null");
        }
        this.encodingMode = mode;
    }

    public void setEmbeddingMode(EmbeddingMode embeddingMode) {
        if (embeddingMode == null) {
            throw new NullPointerException("embeddingMode must not be null");
        }
        this.embeddingMode = embeddingMode;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.embedded = true;
    }

    public String toString() {
        return "metrics-url=" + this.metricsFile + ", embed-url=" + this.embedFile + ", kerning=" + this.kerning + ", advanced=" + this.advanced + ", enc-mode=" + (Object)((Object)this.encodingMode) + ", font-triplet=" + this.fontTriplets + (this.getSubFontName() != null ? ", sub-font=" + this.getSubFontName() : "") + (this.isEmbedded() ? "" : ", NOT embedded");
    }
}

