/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.xmlgraphics.image.loader.impl.ImageRawPNG;
import org.apache.xmlgraphics.ps.ImageEncoder;

public class ImageEncoderPNG
implements ImageEncoder {
    private final ImageRawPNG image;
    private int numberOfInterleavedComponents;

    public ImageEncoderPNG(ImageRawPNG image) {
        this.image = image;
        ColorModel cm = this.image.getColorModel();
        this.numberOfInterleavedComponents = cm instanceof IndexColorModel ? 1 : cm.getNumComponents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException {
        InputStream in = this.image.createInputStream();
        try {
            if (this.numberOfInterleavedComponents == 1 || this.numberOfInterleavedComponents == 3) {
                IOUtils.copy(in, out);
            } else {
                int filter;
                int numBytes = this.numberOfInterleavedComponents - 1;
                int numColumns = this.image.getSize().getWidthPx();
                InflaterInputStream infStream = new InflaterInputStream(in, new Inflater());
                DataInputStream dataStream = new DataInputStream(infStream);
                int offset = 0;
                int bytesPerRow = this.numberOfInterleavedComponents * numColumns;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)baos, new Deflater());
                while ((filter = dataStream.read()) != -1) {
                    byte[] bytes = new byte[bytesPerRow];
                    dataStream.readFully(bytes, 0, bytesPerRow);
                    dos.write((byte)filter);
                    for (int j = 0; j < numColumns; ++j) {
                        dos.write(bytes, offset, numBytes);
                        offset += this.numberOfInterleavedComponents;
                    }
                    offset = 0;
                }
                dos.close();
                IOUtils.copy((InputStream)new ByteArrayInputStream(baos.toByteArray()), out);
            }
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public String getImplicitFilter() {
        String filter = "<< /Predictor 15 /Columns " + this.image.getSize().getWidthPx();
        filter = filter + " /Colors " + (this.numberOfInterleavedComponents > 2 ? 3 : 1);
        filter = filter + " /BitsPerComponent " + this.image.getBitDepth() + " >> /FlateDecode";
        return filter;
    }
}

