/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import javajs.util.P3;
import javajs.util.PT;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Logger;

public class JSONReader
extends AtomSetCollectionReader {
    private P3 scale;

    @Override
    public void initializeReader() throws Exception {
        this.asc.setCollectionName("JSON");
        this.asc.newAtomSet();
        String s = "";
        while (this.rd() != null) {
            s = s + this.line;
        }
        if ((s = PT.replaceAllCharacters(s, "\" ", "").replace(',', ':')).contains("_is2D:true")) {
            this.set2D();
        }
        if (s.contains("_scale:")) {
            this.getScaling(this.getSection(s, "_scale", false));
        }
        s = PT.replaceAllCharacters(s, "}", "").replace(',', ':');
        this.readAtoms(this.getSection(s, "a", true));
        this.readBonds(this.getSection(s, "b", true));
        this.continuing = false;
    }

    private void getScaling(String[] s) {
        String[] xyz = PT.split(s[0], ":");
        this.scale = P3.new3(1.0f, 1.0f, 1.0f);
        block5: for (int j = 0; j < xyz.length; j += 2) {
            if (xyz[j].length() != 1) continue;
            switch (xyz[j].charAt(0)) {
                case 'x': {
                    this.scale.x = this.parseFloatStr(xyz[j + 1]);
                    continue block5;
                }
                case 'y': {
                    this.scale.y = this.parseFloatStr(xyz[j + 1]);
                    continue block5;
                }
                case 'z': {
                    this.scale.z = this.parseFloatStr(xyz[j + 1]);
                }
            }
        }
        Logger.info("scale set to " + this.scale);
    }

    private String[] getSection(String json, String key, boolean isArray) {
        String[] a = PT.split(json, key + ":" + (isArray ? "[" : "") + "{");
        if (a.length < 2) {
            return a;
        }
        String data = a[1];
        data = data.substring(0, data.indexOf(isArray ? "]" : "}")) + ":";
        return PT.split(data, "{");
    }

    private void readAtoms(String[] atoms) throws Exception {
        for (int i = 0; i < atoms.length; ++i) {
            String[] lxyz = PT.split(atoms[i], ":");
            Atom atom = this.asc.addNewAtom();
            float x = 0.0f;
            float y = 0.0f;
            float z = 0.0f;
            String l = "C";
            block7: for (int j = 0; j < lxyz.length; j += 2) {
                if (lxyz[j].length() != 1) continue;
                switch (lxyz[j].charAt(0)) {
                    case 'x': {
                        x = this.parseFloatStr(lxyz[j + 1]);
                        continue block7;
                    }
                    case 'y': {
                        y = this.parseFloatStr(lxyz[j + 1]);
                        continue block7;
                    }
                    case 'z': {
                        z = this.parseFloatStr(lxyz[j + 1]);
                        continue block7;
                    }
                    case 'l': {
                        l = lxyz[j + 1];
                    }
                }
            }
            if (this.scale != null) {
                x /= this.scale.x;
                y /= this.scale.y;
                z /= this.scale.z;
            }
            this.setAtomCoordXYZ(atom, x, y, z);
            atom.elementSymbol = l;
        }
    }

    private void readBonds(String[] bonds) throws Exception {
        for (int i = 0; i < bonds.length; ++i) {
            String[] beo = PT.split(bonds[i], ":");
            int b = 0;
            int e = 0;
            int order = 1;
            block13: for (int j = 0; j < beo.length; j += 2) {
                if (beo[j].length() != 1) continue;
                switch (beo[j].charAt(0)) {
                    case 'b': {
                        b = this.parseIntStr(beo[j + 1]);
                        continue block13;
                    }
                    case 'e': {
                        e = this.parseIntStr(beo[j + 1]);
                        continue block13;
                    }
                    case 'o': {
                        int o = (int)(this.parseFloatStr(beo[j + 1]) * 2.0f);
                        switch (o) {
                            case 0: {
                                continue block13;
                            }
                            case 2: 
                            case 4: 
                            case 6: 
                            case 8: {
                                order = o / 2;
                                continue block13;
                            }
                            case 1: {
                                order = 33;
                                continue block13;
                            }
                            case 3: {
                                order = 66;
                                continue block13;
                            }
                            case 5: {
                                order = 97;
                                continue block13;
                            }
                        }
                        order = 1;
                    }
                }
            }
            this.asc.addBond(new Bond(b, e, order));
        }
    }
}

