/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.threadpool;

public final class PoolConfiguration
implements Cloneable {
    private boolean useBoundary = true;
    private int boundarySize = 2000;
    private int maximumPoolSize = 150;
    private int minimumPoolSize = 4;
    private int keepAliveTime = 300000;
    private WhenBlockedPolicy whenBlockedPolicy = WhenBlockedPolicy.RUN;
    private int startUpSize = 4;

    public void setUseBoundary(boolean bl) {
        this.useBoundary = bl;
    }

    public boolean isUseBoundary() {
        return this.useBoundary;
    }

    public PoolConfiguration() {
    }

    public PoolConfiguration(boolean bl, int n, int n2, int n3, int n4, WhenBlockedPolicy whenBlockedPolicy, int n5) {
        this.setUseBoundary(bl);
        this.setBoundarySize(n);
        this.setMaximumPoolSize(n2);
        this.setMinimumPoolSize(n3);
        this.setKeepAliveTime(n4);
        this.setWhenBlockedPolicy(whenBlockedPolicy);
        this.setStartUpSize(n5);
    }

    public void setBoundarySize(int n) {
        this.boundarySize = n;
    }

    public int getBoundarySize() {
        return this.boundarySize;
    }

    public void setMaximumPoolSize(int n) {
        this.maximumPoolSize = n;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setMinimumPoolSize(int n) {
        this.minimumPoolSize = n;
    }

    public int getMinimumPoolSize() {
        return this.minimumPoolSize;
    }

    public void setKeepAliveTime(int n) {
        this.keepAliveTime = n;
    }

    public int getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setWhenBlockedPolicy(String string) {
        if (string != null) {
            WhenBlockedPolicy whenBlockedPolicy = WhenBlockedPolicy.valueOf(string.trim().toUpperCase());
            this.setWhenBlockedPolicy(whenBlockedPolicy);
        } else {
            this.whenBlockedPolicy = WhenBlockedPolicy.RUN;
        }
    }

    public void setWhenBlockedPolicy(WhenBlockedPolicy whenBlockedPolicy) {
        this.whenBlockedPolicy = whenBlockedPolicy != null ? whenBlockedPolicy : WhenBlockedPolicy.RUN;
    }

    public WhenBlockedPolicy getWhenBlockedPolicy() {
        return this.whenBlockedPolicy;
    }

    public void setStartUpSize(int n) {
        this.startUpSize = n;
    }

    public int getStartUpSize() {
        return this.startUpSize;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("useBoundary = [" + this.isUseBoundary() + "] ");
        stringBuilder.append("boundarySize = [" + this.boundarySize + "] ");
        stringBuilder.append("maximumPoolSize = [" + this.maximumPoolSize + "] ");
        stringBuilder.append("minimumPoolSize = [" + this.minimumPoolSize + "] ");
        stringBuilder.append("keepAliveTime = [" + this.keepAliveTime + "] ");
        stringBuilder.append("whenBlockedPolicy = [" + (Object)((Object)this.getWhenBlockedPolicy()) + "] ");
        stringBuilder.append("startUpSize = [" + this.startUpSize + "]");
        return stringBuilder.toString();
    }

    public PoolConfiguration clone() {
        return new PoolConfiguration(this.isUseBoundary(), this.boundarySize, this.maximumPoolSize, this.minimumPoolSize, this.keepAliveTime, this.getWhenBlockedPolicy(), this.startUpSize);
    }

    public static enum WhenBlockedPolicy {
        ABORT,
        BLOCK,
        RUN,
        WAIT,
        DISCARDOLDEST;

    }
}

