/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Objects;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;

public class Coordinate
implements ICoordinate {
    private transient Point2D.Double data;

    public Coordinate(double d, double d2) {
        this.data = new Point2D.Double(d2, d);
    }

    @Override
    public double getLat() {
        return this.data.y;
    }

    @Override
    public void setLat(double d) {
        this.data.y = d;
    }

    @Override
    public double getLon() {
        return this.data.x;
    }

    @Override
    public void setLon(double d) {
        this.data.x = d;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.data.x);
        objectOutputStream.writeObject(this.data.y);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.data = new Point2D.Double();
        this.data.x = (Double)objectInputStream.readObject();
        this.data.y = (Double)objectInputStream.readObject();
    }

    public String toString() {
        return "Coordinate[" + this.data.y + ", " + this.data.x + ']';
    }

    public int hashCode() {
        int n = 3;
        n = 61 * n + Objects.hashCode(this.data);
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Coordinate coordinate = (Coordinate)object;
        return Objects.equals(this.data, coordinate.data);
    }
}

