/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command.conflict;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.openstreetmap.josm.command.conflict.ConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMergeItem;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class TagConflictResolveCommand
extends ConflictResolveCommand {
    private final Conflict<? extends OsmPrimitive> conflict;
    private final List<TagMergeItem> mergeItems;

    public int getNumDecidedConflicts() {
        int n = 0;
        for (TagMergeItem tagMergeItem : this.mergeItems) {
            if (tagMergeItem.getMergeDecision().equals((Object)MergeDecisionType.UNDECIDED)) continue;
            ++n;
        }
        return n;
    }

    public TagConflictResolveCommand(Conflict<? extends OsmPrimitive> conflict, List<TagMergeItem> list) {
        this.conflict = conflict;
        this.mergeItems = list;
    }

    @Override
    public String getDescriptionText() {
        switch (OsmPrimitiveType.from(this.conflict.getMy())) {
            case NODE: {
                return I18n.trn("Resolve {0} tag conflict in node {1}", "Resolve {0} tag conflicts in node {1}", this.getNumDecidedConflicts(), this.getNumDecidedConflicts(), this.conflict.getMy().getId());
            }
            case WAY: {
                return I18n.trn("Resolve {0} tag conflict in way {1}", "Resolve {0} tag conflicts in way {1}", this.getNumDecidedConflicts(), this.getNumDecidedConflicts(), this.conflict.getMy().getId());
            }
            case RELATION: {
                return I18n.trn("Resolve {0} tag conflict in relation {1}", "Resolve {0} tag conflicts in relation {1}", this.getNumDecidedConflicts(), this.getNumDecidedConflicts(), this.conflict.getMy().getId());
            }
        }
        return "";
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "object");
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        for (TagMergeItem tagMergeItem : this.mergeItems) {
            if (tagMergeItem.getMergeDecision().equals((Object)MergeDecisionType.UNDECIDED)) continue;
            tagMergeItem.applyToMyPrimitive(this.conflict.getMy());
        }
        this.rememberConflict(this.conflict);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.add(this.conflict.getMy());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.conflict, this.mergeItems);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        TagConflictResolveCommand tagConflictResolveCommand = (TagConflictResolveCommand)object;
        return Objects.equals(this.conflict, tagConflictResolveCommand.conflict) && Objects.equals(this.mergeItems, tagConflictResolveCommand.mergeItems);
    }
}

