/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.proj.AbstractProj;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;

public class CassiniSoldner
extends AbstractProj {
    private double ml0;
    private static final double C1 = 0.16666666666666666;
    private static final double C2 = 0.008333333333333333;
    private static final double C3 = 0.041666666666666664;
    private static final double C4 = 0.3333333333333333;
    private static final double C5 = 0.06666666666666667;

    @Override
    public String getName() {
        return I18n.tr("Cassini-Soldner", new Object[0]);
    }

    @Override
    public String getProj4Id() {
        return "cass";
    }

    @Override
    public void initialize(ProjParameters projParameters) throws ProjectionConfigurationException {
        super.initialize(projParameters);
        if (projParameters.lat0 == null) {
            throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "lat_0"));
        }
        double d = Math.toRadians(projParameters.lat0);
        this.ml0 = this.mlfn(d, Math.sin(d), Math.cos(d));
    }

    @Override
    public double[] project(double d, double d2) {
        double d3 = Math.sin(d);
        double d4 = Math.cos(d);
        double d5 = 1.0 / Math.sqrt(1.0 - this.e2 * d3 * d3);
        double d6 = Math.tan(d);
        double d7 = d6 * d6;
        double d8 = d2 * d4;
        double d9 = d4 * d4 * this.e2 / (1.0 - this.e2);
        double d10 = d8 * d8;
        double d11 = d5 * d8 * (1.0 - d10 * d7 * (0.16666666666666666 - (8.0 - d7 + 8.0 * d9) * d10 * 0.008333333333333333));
        double d12 = this.mlfn(d, d3, d4) - this.ml0 + d5 * d6 * d10 * (0.5 + (5.0 - d7 + 6.0 * d9) * d10 * 0.041666666666666664);
        return new double[]{d11, d12};
    }

    @Override
    public double[] invproject(double d, double d2) {
        double d3 = this.invMlfn(this.ml0 + d2);
        double d4 = Math.tan(d3);
        double d5 = d4 * d4;
        double d6 = Math.sin(d3);
        double d7 = 1.0 / (1.0 - this.e2 * d6 * d6);
        d6 = Math.sqrt(d7);
        double d8 = d / d6;
        double d9 = d8 * d8;
        double d10 = d3 - d6 * d4 / (d7 *= (1.0 - this.e2) * d6) * d9 * (0.5 - (1.0 + 3.0 * d5) * d9 * 0.041666666666666664);
        double d11 = d8 * (1.0 + d5 * d9 * (-0.3333333333333333 + (1.0 + 3.0 * d5) * d9 * 0.06666666666666667)) / Math.cos(d3);
        return new double[]{d10, d11};
    }

    @Override
    public Bounds getAlgorithmBounds() {
        return new Bounds(-89.0, -1.0, 89.0, 1.0, false);
    }
}

