/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public final class ConditionalOptionPaneUtil {
    public static final int DIALOG_DISABLED_OPTION = Integer.MIN_VALUE;
    private static final Map<String, Integer> sessionChoices = new HashMap<String, Integer>();
    private static final Map<String, Integer> immediateChoices = new HashMap<String, Integer>();
    private static final Set<String> immediateActive = new HashSet<String>();

    private ConditionalOptionPaneUtil() {
    }

    public static int getDialogReturnValue(String string) {
        return Utils.firstNonNull(immediateChoices.get(string), sessionChoices.get(string), !Main.pref.getBoolean("message." + string, true) ? Main.pref.getInteger("message." + string + ".value", -1) : -1);
    }

    public static void startBulkOperation(String string) {
        immediateActive.add(string);
    }

    public static boolean isInBulkOperation(String string) {
        return immediateActive.contains(string);
    }

    public static void endBulkOperation(String string) {
        immediateActive.remove(string);
        immediateChoices.remove(string);
    }

    public static int showOptionDialog(String string, Component component, Object object, String string2, int n, int n2, Object[] objectArray, Object object2) {
        int n3 = ConditionalOptionPaneUtil.getDialogReturnValue(string);
        if (ConditionalOptionPaneUtil.isYesOrNo(n3)) {
            return n3;
        }
        MessagePanel messagePanel = new MessagePanel(object, ConditionalOptionPaneUtil.isInBulkOperation(string));
        n3 = GraphicsEnvironment.isHeadless() ? 0 : JOptionPane.showOptionDialog(component, messagePanel, string2, n, n2, null, objectArray, object2);
        if (ConditionalOptionPaneUtil.isYesOrNo(n3)) {
            messagePanel.getNotShowAgain().store(string, n3);
        }
        return n3;
    }

    public static boolean showConfirmationDialog(String string, Component component, Object object, String string2, int n, int n2, int n3) {
        int n4 = ConditionalOptionPaneUtil.getDialogReturnValue(string);
        if (ConditionalOptionPaneUtil.isYesOrNo(n4)) {
            return n4 == n3;
        }
        MessagePanel messagePanel = new MessagePanel(object, ConditionalOptionPaneUtil.isInBulkOperation(string));
        n4 = GraphicsEnvironment.isHeadless() ? n3 : JOptionPane.showConfirmDialog(component, messagePanel, string2, n, n2);
        if (ConditionalOptionPaneUtil.isYesOrNo(n4)) {
            messagePanel.getNotShowAgain().store(string, n4);
        }
        return n4 == n3;
    }

    private static boolean isYesOrNo(int n) {
        return n == 0 || n == 1;
    }

    public static void showMessageDialog(String string, Component component, Object object, String string2, int n) {
        if (ConditionalOptionPaneUtil.getDialogReturnValue(string) == Integer.MAX_VALUE) {
            return;
        }
        MessagePanel messagePanel = new MessagePanel(object, ConditionalOptionPaneUtil.isInBulkOperation(string));
        JOptionPane.showMessageDialog(component, messagePanel, string2, n);
        messagePanel.getNotShowAgain().store(string, Integer.MAX_VALUE);
    }

    static class MessagePanel
    extends JPanel {
        private final JRadioButton cbShowPermanentDialog = new JRadioButton(NotShowAgain.PERMANENT.getLabel());
        private final JRadioButton cbShowSessionDialog = new JRadioButton(NotShowAgain.SESSION.getLabel());
        private final JRadioButton cbShowImmediateDialog = new JRadioButton(NotShowAgain.OPERATION.getLabel());
        private final JRadioButton cbStandard = new JRadioButton(NotShowAgain.NO.getLabel());

        MessagePanel(Object object, boolean bl) {
            this.cbStandard.setSelected(true);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.cbShowPermanentDialog);
            buttonGroup.add(this.cbShowSessionDialog);
            buttonGroup.add(this.cbShowImmediateDialog);
            buttonGroup.add(this.cbStandard);
            this.setLayout(new GridBagLayout());
            if (object instanceof Component) {
                this.add((Component)object, GBC.eop());
            } else if (object != null) {
                this.add((Component)new JMultilineLabel(object.toString()), GBC.eop());
            }
            this.add((Component)this.cbShowPermanentDialog, GBC.eol());
            this.add((Component)this.cbShowSessionDialog, GBC.eol());
            if (bl) {
                this.add((Component)this.cbShowImmediateDialog, GBC.eol());
            }
            this.add((Component)this.cbStandard, GBC.eol());
        }

        NotShowAgain getNotShowAgain() {
            return this.cbStandard.isSelected() ? NotShowAgain.NO : (this.cbShowImmediateDialog.isSelected() ? NotShowAgain.OPERATION : (this.cbShowSessionDialog.isSelected() ? NotShowAgain.SESSION : (this.cbShowPermanentDialog.isSelected() ? NotShowAgain.PERMANENT : null)));
        }
    }

    static enum NotShowAgain {
        NO,
        OPERATION,
        SESSION,
        PERMANENT;


        void store(String string, Integer n) {
            switch (this) {
                case NO: {
                    break;
                }
                case OPERATION: {
                    immediateChoices.put(string, n);
                    break;
                }
                case SESSION: {
                    sessionChoices.put(string, n);
                    break;
                }
                case PERMANENT: {
                    Main.pref.put("message." + string, false);
                    Main.pref.putInteger("message." + string + ".value", n);
                }
            }
        }

        String getLabel() {
            switch (this) {
                case NO: {
                    return I18n.tr("Show this dialog again the next time", new Object[0]);
                }
                case OPERATION: {
                    return I18n.tr("Do not show again (this operation)", new Object[0]);
                }
                case SESSION: {
                    return I18n.tr("Do not show again (this session)", new Object[0]);
                }
                case PERMANENT: {
                    return I18n.tr("Do not show again (remembers choice)", new Object[0]);
                }
            }
            throw new IllegalStateException();
        }
    }
}

