/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectionSynchronizer
implements ListSelectionListener {
    private final Set<ListSelectionModel> participants = new HashSet<ListSelectionModel>();
    private boolean preventRecursion;

    public void participateInSynchronizedSelection(ListSelectionModel listSelectionModel) {
        if (listSelectionModel == null) {
            return;
        }
        if (this.participants.contains(listSelectionModel)) {
            return;
        }
        this.participants.add(listSelectionModel);
        listSelectionModel.addListSelectionListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.preventRecursion) {
            return;
        }
        this.preventRecursion = true;
        DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
        int n = defaultListSelectionModel.getMinSelectionIndex();
        for (ListSelectionModel listSelectionModel : this.participants) {
            if (listSelectionModel == listSelectionEvent.getSource()) continue;
            listSelectionModel.setSelectionInterval(n, n);
        }
        this.preventRecursion = false;
    }
}

