/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.gui.widgets.FileChooserManager;
import org.openstreetmap.josm.io.JpgImporter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class ImportImagesAction
extends AbstractAction {
    private final transient GpxLayer layer;

    public ImportImagesAction(GpxLayer gpxLayer) {
        super(I18n.tr("Import images", new Object[0]), ImageProvider.get("dialogs/geoimage"));
        this.layer = gpxLayer;
        this.putValue("help", HelpUtil.ht("/Action/ImportImages"));
    }

    private static void warnCantImportIntoServerLayer(GpxLayer gpxLayer) {
        String string = I18n.tr("<html>The data in the GPX layer ''{0}'' has been downloaded from the server.<br>Because its way points do not include a timestamp we cannot correlate them with images.</html>", gpxLayer.getName());
        HelpAwareOptionPane.showOptionDialog(Main.parent, string, I18n.tr("Import not possible", new Object[0]), 2, HelpUtil.ht("/Action/ImportImages#CantImportIntoGpxLayerFromServer"));
    }

    private static void addRecursiveFiles(List<File> list, File ... fileArray) {
        if (fileArray == null) {
            return;
        }
        for (File file : fileArray) {
            if (file.isDirectory()) {
                ImportImagesAction.addRecursiveFiles(list, file.listFiles());
                continue;
            }
            if (!Utils.hasExtension(file, "jpg")) continue;
            list.add(file);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        File[] fileArray;
        if (this.layer.data.fromServer) {
            ImportImagesAction.warnCantImportIntoServerLayer(this.layer);
            return;
        }
        JpgImporter jpgImporter = new JpgImporter(this.layer);
        AbstractFileChooser abstractFileChooser = new FileChooserManager(true, "geoimage.lastdirectory", Main.pref.get("lastDirectory")).createFileChooser(true, null, jpgImporter.filter, 2).openFileChooser();
        if (abstractFileChooser != null && (fileArray = abstractFileChooser.getSelectedFiles()) != null && fileArray.length > 0) {
            LinkedList<File> linkedList = new LinkedList<File>();
            ImportImagesAction.addRecursiveFiles(linkedList, fileArray);
            jpgImporter.importDataHandleExceptions(linkedList, NullProgressMonitor.INSTANCE);
        }
    }
}

