/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.layer.markerlayer.ButtonMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.tools.ImageProvider;

public class ImageMarker
extends ButtonMarker {
    public URL imageUrl;

    public ImageMarker(LatLon latLon, URL uRL, MarkerLayer markerLayer, double d, double d2) {
        super(latLon, "photo", markerLayer, d, d2);
        this.imageUrl = uRL;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent2) {
        JPanel jPanel = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(new JLabel(ImageMarker.loadScaledImage(this.imageUrl, 580)));
        JViewport jViewport = jScrollPane.getViewport();
        jPanel.add((Component)jScrollPane, "Center");
        JToggleButton jToggleButton = new JToggleButton(ImageProvider.get("misc", "rectangle"));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jToggleButton);
        jPanel.add((Component)jPanel2, "South");
        jToggleButton.addActionListener(actionEvent -> {
            jPanel.setCursor(Cursor.getPredefinedCursor(3));
            if (jToggleButton.getModel().isSelected()) {
                ((JLabel)jViewport.getView()).setIcon(ImageMarker.loadScaledImage(this.imageUrl, Math.max(jViewport.getWidth(), jViewport.getHeight())));
            } else {
                ((JLabel)jViewport.getView()).setIcon(new ImageIcon(this.imageUrl));
            }
            jPanel.setCursor(Cursor.getDefaultCursor());
        });
        jToggleButton.setSelected(true);
        JOptionPane jOptionPane = new JOptionPane(jPanel, -1);
        if (!GraphicsEnvironment.isHeadless()) {
            JDialog jDialog = jOptionPane.createDialog(Main.parent, this.imageUrl.toString());
            jDialog.setModal(false);
            jDialog.toFront();
            jDialog.setVisible(true);
        }
    }

    private static Icon loadScaledImage(URL uRL, int n) {
        int n2;
        Image image = new ImageIcon(uRL).getImage();
        int n3 = image.getWidth(null);
        if (n3 > (n2 = image.getHeight(null))) {
            n2 = (int)Math.round((double)n * ((double)n2 / (double)n3));
            n3 = n;
        } else {
            n3 = (int)Math.round((double)n * ((double)n3 / (double)n2));
            n2 = n;
        }
        return new ImageIcon(image.getScaledInstance(n3, n2, 4));
    }

    @Override
    public WayPoint convertToWayPoint() {
        WayPoint wayPoint = super.convertToWayPoint();
        GpxLink gpxLink = new GpxLink(this.imageUrl.toString());
        gpxLink.type = "image";
        wayPoint.put("meta.links", Collections.singleton(gpxLink));
        return wayPoint;
    }
}

