/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.remotecontrol;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.RemoteControl;
import org.openstreetmap.josm.io.remotecontrol.RemoteControlHttpsServer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.PlatformHookWindows;

public final class RemoteControlPreference
extends DefaultTabPreferenceSetting {
    private final Map<PermissionPrefWithDefault, JCheckBox> prefs = new LinkedHashMap<PermissionPrefWithDefault, JCheckBox>();
    private JCheckBox enableRemoteControl;
    private JCheckBox enableHttpsSupport;
    private JButton installCertificate;
    private JButton uninstallCertificate;
    private final JCheckBox loadInNewLayer = new JCheckBox(I18n.tr("Download objects to new layer", new Object[0]));
    private final JCheckBox alwaysAskUserConfirm = new JCheckBox(I18n.tr("Confirm all Remote Control actions manually", new Object[0]));

    private RemoteControlPreference() {
        super("remotecontrol", I18n.tr("Remote Control", new Object[0]), I18n.tr("Settings for the remote control feature.", new Object[0]));
        for (PermissionPrefWithDefault permissionPrefWithDefault : PermissionPrefWithDefault.getPermissionPrefs()) {
            JCheckBox jCheckBox = new JCheckBox(permissionPrefWithDefault.preferenceText);
            jCheckBox.setSelected(permissionPrefWithDefault.isAllowed());
            this.prefs.put(permissionPrefWithDefault, jCheckBox);
        }
    }

    @Override
    public void addGui(PreferenceTabbedPane preferenceTabbedPane) {
        VerticallyScrollablePanel verticallyScrollablePanel = new VerticallyScrollablePanel(new GridBagLayout());
        JLabel jLabel = new JLabel("<html>" + I18n.tr("Allows JOSM to be controlled from other applications, e.g. from a web browser.", new Object[0]) + "</html>");
        jLabel.setFont(jLabel.getFont().deriveFont(0));
        verticallyScrollablePanel.add((Component)jLabel, GBC.eol().insets(5, 5, 0, 10).fill(2));
        JLabel jLabel2 = new JLabel("<html>" + I18n.tr("JOSM will always listen at <b>port {0}</b> (http) and <b>port {1}</b> (https) on localhost.<br>These ports are not configurable because they are referenced by external applications talking to JOSM.", Main.pref.get("remote.control.port", "8111"), Main.pref.get("remote.control.https.port", "8112")) + "</html>");
        jLabel2.setFont(jLabel2.getFont().deriveFont(0));
        verticallyScrollablePanel.add((Component)jLabel2, GBC.eol().insets(5, 5, 0, 10).fill(2));
        this.enableRemoteControl = new JCheckBox(I18n.tr("Enable remote control", new Object[0]), (boolean)RemoteControl.PROP_REMOTECONTROL_ENABLED.get());
        verticallyScrollablePanel.add((Component)this.enableRemoteControl, GBC.eol());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray)));
        verticallyScrollablePanel.add((Component)jPanel, GBC.eol().fill(2).insets(5, 5, 5, 5));
        boolean bl = RemoteControl.PROP_REMOTECONTROL_HTTPS_ENABLED.get();
        this.enableHttpsSupport = new JCheckBox(I18n.tr("Enable HTTPS support", new Object[0]), bl);
        jPanel.add((Component)this.enableHttpsSupport, GBC.eol().fill(2));
        if (Main.isPlatformWindows()) {
            this.installCertificate = new JButton(I18n.tr("Install...", new Object[0]));
            this.uninstallCertificate = new JButton(I18n.tr("Uninstall...", new Object[0]));
            this.installCertificate.setToolTipText(I18n.tr("Install JOSM localhost certificate to system/browser root keystores", new Object[0]));
            this.uninstallCertificate.setToolTipText(I18n.tr("Uninstall JOSM localhost certificate from system/browser root keystores", new Object[0]));
            jPanel.add((Component)new JLabel(I18n.tr("Certificate:", new Object[0])), GBC.std().insets(15, 5, 0, 0));
            jPanel.add((Component)this.installCertificate, GBC.std().insets(5, 5, 0, 0));
            jPanel.add((Component)this.uninstallCertificate, GBC.eol().insets(5, 5, 0, 0));
            this.enableHttpsSupport.addActionListener(actionEvent -> this.installCertificate.setEnabled(this.enableHttpsSupport.isSelected()));
            this.installCertificate.addActionListener(actionEvent -> {
                try {
                    boolean bl = RemoteControlHttpsServer.setupPlatform(RemoteControlHttpsServer.loadJosmKeystore());
                    String string = bl ? I18n.tr("Certificate has been successfully installed.", new Object[0]) : I18n.tr("Certificate is already installed. Nothing to do.", new Object[0]);
                    Main.info(string);
                    JOptionPane.showMessageDialog(jPanel, string);
                }
                catch (IOException | GeneralSecurityException exception) {
                    Main.error(exception);
                }
            });
            this.uninstallCertificate.addActionListener(actionEvent -> {
                try {
                    String string;
                    KeyStore keyStore = PlatformHookWindows.getRootKeystore();
                    if (keyStore.containsAlias("josm_localhost")) {
                        Main.info(I18n.tr("Removing certificate {0} from root keystore.", "josm_localhost"));
                        keyStore.deleteEntry("josm_localhost");
                        string = I18n.tr("Certificate has been successfully uninstalled.", new Object[0]);
                    } else {
                        string = I18n.tr("Certificate is not installed. Nothing to do.", new Object[0]);
                    }
                    Main.info(string);
                    JOptionPane.showMessageDialog(jPanel, string);
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
                    Main.error(exception);
                }
            });
            this.installCertificate.setEnabled(bl);
        }
        jPanel.add((Component)new JSeparator(), GBC.eop().fill(2).insets(15, 5, 15, 5));
        jPanel.add((Component)new JLabel(I18n.tr("Permitted actions:", new Object[0])), GBC.eol().insets(5, 0, 0, 0));
        for (JCheckBox jCheckBox : this.prefs.values()) {
            jPanel.add((Component)jCheckBox, GBC.eol().insets(15, 5, 0, 0).fill(2));
        }
        jPanel.add((Component)new JSeparator(), GBC.eop().fill(2).insets(15, 5, 15, 5));
        jPanel.add((Component)this.loadInNewLayer, GBC.eol().fill(2));
        jPanel.add((Component)this.alwaysAskUserConfirm, GBC.eol().fill(2));
        verticallyScrollablePanel.add(Box.createVerticalGlue(), GBC.eol().fill(3));
        this.loadInNewLayer.setSelected(Main.pref.getBoolean("remotecontrol.new-layer", false));
        this.alwaysAskUserConfirm.setSelected(Main.pref.getBoolean("remotecontrol.always-confirm", false));
        ActionListener actionListener = actionEvent -> {
            GuiHelper.setEnabledRec(jPanel, this.enableRemoteControl.isSelected());
            if (this.installCertificate != null && this.uninstallCertificate != null) {
                this.installCertificate.setEnabled(this.enableRemoteControl.isSelected() && this.enableHttpsSupport.isSelected());
                this.uninstallCertificate.setEnabled(true);
            }
        };
        this.enableRemoteControl.addActionListener(actionListener);
        actionListener.actionPerformed(null);
        this.createPreferenceTabWithScrollPane(preferenceTabbedPane, verticallyScrollablePanel);
    }

    @Override
    public boolean ok() {
        boolean bl = this.enableRemoteControl.isSelected();
        boolean bl2 = this.enableHttpsSupport.isSelected();
        boolean bl3 = RemoteControl.PROP_REMOTECONTROL_ENABLED.put(bl);
        boolean bl4 = RemoteControl.PROP_REMOTECONTROL_HTTPS_ENABLED.put(bl2);
        if (bl) {
            for (Map.Entry<PermissionPrefWithDefault, JCheckBox> entry : this.prefs.entrySet()) {
                Main.pref.put(entry.getKey().pref, entry.getValue().isSelected());
            }
            Main.pref.put("remotecontrol.new-layer", this.loadInNewLayer.isSelected());
            Main.pref.put("remotecontrol.always-confirm", this.alwaysAskUserConfirm.isSelected());
        }
        if (bl3) {
            if (bl) {
                RemoteControl.start();
            } else {
                RemoteControl.stop();
            }
        } else if (bl4) {
            if (bl2) {
                RemoteControlHttpsServer.restartRemoteControlHttpsServer();
            } else {
                RemoteControlHttpsServer.stopRemoteControlHttpsServer();
            }
        }
        return false;
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new RemoteControlPreference();
        }
    }
}

