/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.OutputStream;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.StreamProgressUpdater;
import org.openstreetmap.josm.tools.I18n;

public class ProgressOutputStream
extends OutputStream {
    private final StreamProgressUpdater updater;
    private final OutputStream out;
    private final boolean finishOnClose;

    public ProgressOutputStream(OutputStream outputStream, long l, ProgressMonitor progressMonitor, boolean bl) {
        this.updater = new StreamProgressUpdater(l, progressMonitor != null ? progressMonitor : NullProgressMonitor.INSTANCE, I18n.tr("Uploading data ...", new Object[0]));
        this.out = outputStream;
        this.finishOnClose = bl;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.updater.advanceTicker(n2);
    }

    @Override
    public void write(int n) throws IOException {
        this.out.write(n);
        this.updater.advanceTicker(1);
    }

    @Override
    public void close() throws IOException {
        try {
            this.out.close();
        }
        finally {
            if (this.finishOnClose) {
                this.updater.finishTask();
            }
        }
    }
}

