/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import org.openstreetmap.josm.io.CachedFile;

public final class FontsManager {
    private static final Collection<String> INCLUDED_FONTS = Arrays.asList("DroidSans.ttf", "DroidSans-Bold.ttf");

    private FontsManager() {
    }

    public static void initialize() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (String string : INCLUDED_FONTS) {
            String string2 = "resource://data/fonts/" + string;
            try {
                CachedFile cachedFile = new CachedFile(string2);
                Throwable throwable = null;
                try {
                    InputStream inputStream = cachedFile.getInputStream();
                    Throwable throwable2 = null;
                    try {
                        graphicsEnvironment.registerFont(Font.createFont(0, inputStream));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (cachedFile == null) continue;
                    if (throwable != null) {
                        try {
                            cachedFile.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    cachedFile.close();
                }
            }
            catch (FontFormatException | IOException exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

