/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.ext.openssl.X509Attribute;
import org.jruby.ext.openssl.X509CRL;
import org.jruby.ext.openssl.X509Cert;
import org.jruby.ext.openssl.X509Extension;
import org.jruby.ext.openssl.X509Name;
import org.jruby.ext.openssl.X509Request;
import org.jruby.ext.openssl.X509Revoked;
import org.jruby.ext.openssl.X509Store;
import org.jruby.ext.openssl.x509store.X509Error;
import org.jruby.ext.openssl.x509store.X509Utils;
import org.jruby.runtime.builtin.IRubyObject;

public class X509 {
    public static void createX509(Ruby runtime, RubyModule _OpenSSL) {
        RubyModule _X509 = _OpenSSL.defineModuleUnder("X509");
        X509Name.createX509Name(runtime, _X509);
        X509Cert.createX509Cert(runtime, _X509);
        X509Extension.createX509Extension(runtime, _X509);
        X509CRL.createX509CRL(runtime, _X509);
        X509Revoked.createX509Revoked(runtime, _X509);
        X509Store.createX509Store(runtime, _X509);
        X509Request.createRequest(runtime, _X509);
        X509Attribute.createAttribute(runtime, _X509);
        RubyFixnum _1 = runtime.newFixnum(1);
        RubyFixnum _2 = runtime.newFixnum(2);
        RubyFixnum _3 = runtime.newFixnum(3);
        RubyFixnum _4 = runtime.newFixnum(4);
        RubyFixnum _5 = runtime.newFixnum(5);
        RubyFixnum _6 = runtime.newFixnum(6);
        RubyFixnum _7 = runtime.newFixnum(7);
        RubyFixnum _8 = runtime.newFixnum(8);
        _X509.setConstant("V_OK", (IRubyObject)runtime.newFixnum(0));
        _X509.setConstant("V_ERR_UNABLE_TO_GET_ISSUER_CERT", (IRubyObject)_2);
        _X509.setConstant("V_ERR_UNABLE_TO_GET_CRL", (IRubyObject)_3);
        _X509.setConstant("V_ERR_UNABLE_TO_DECRYPT_CERT_SIGNATURE", (IRubyObject)_4);
        _X509.setConstant("V_ERR_UNABLE_TO_DECRYPT_CRL_SIGNATURE", (IRubyObject)_5);
        _X509.setConstant("V_ERR_UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY", (IRubyObject)_6);
        _X509.setConstant("V_ERR_CERT_SIGNATURE_FAILURE", (IRubyObject)_7);
        _X509.setConstant("V_ERR_CRL_SIGNATURE_FAILURE", (IRubyObject)_8);
        _X509.setConstant("V_ERR_CERT_NOT_YET_VALID", (IRubyObject)runtime.newFixnum(9));
        _X509.setConstant("V_ERR_CERT_HAS_EXPIRED", (IRubyObject)runtime.newFixnum(10));
        _X509.setConstant("V_ERR_CRL_NOT_YET_VALID", (IRubyObject)runtime.newFixnum(11));
        _X509.setConstant("V_ERR_CRL_HAS_EXPIRED", (IRubyObject)runtime.newFixnum(12));
        _X509.setConstant("V_ERR_ERROR_IN_CERT_NOT_BEFORE_FIELD", (IRubyObject)runtime.newFixnum(13));
        _X509.setConstant("V_ERR_ERROR_IN_CERT_NOT_AFTER_FIELD", (IRubyObject)runtime.newFixnum(14));
        _X509.setConstant("V_ERR_ERROR_IN_CRL_LAST_UPDATE_FIELD", (IRubyObject)runtime.newFixnum(15));
        _X509.setConstant("V_ERR_ERROR_IN_CRL_NEXT_UPDATE_FIELD", (IRubyObject)runtime.newFixnum(16));
        _X509.setConstant("V_ERR_OUT_OF_MEM", (IRubyObject)runtime.newFixnum(17));
        _X509.setConstant("V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT", (IRubyObject)runtime.newFixnum(18));
        _X509.setConstant("V_ERR_SELF_SIGNED_CERT_IN_CHAIN", (IRubyObject)runtime.newFixnum(19));
        _X509.setConstant("V_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY", (IRubyObject)runtime.newFixnum(20));
        _X509.setConstant("V_ERR_UNABLE_TO_VERIFY_LEAF_SIGNATURE", (IRubyObject)runtime.newFixnum(21));
        _X509.setConstant("V_ERR_CERT_CHAIN_TOO_LONG", (IRubyObject)runtime.newFixnum(22));
        _X509.setConstant("V_ERR_CERT_REVOKED", (IRubyObject)runtime.newFixnum(23));
        _X509.setConstant("V_ERR_INVALID_CA", (IRubyObject)runtime.newFixnum(24));
        _X509.setConstant("V_ERR_PATH_LENGTH_EXCEEDED", (IRubyObject)runtime.newFixnum(25));
        _X509.setConstant("V_ERR_INVALID_PURPOSE", (IRubyObject)runtime.newFixnum(26));
        _X509.setConstant("V_ERR_CERT_UNTRUSTED", (IRubyObject)runtime.newFixnum(27));
        _X509.setConstant("V_ERR_CERT_REJECTED", (IRubyObject)runtime.newFixnum(28));
        _X509.setConstant("V_ERR_SUBJECT_ISSUER_MISMATCH", (IRubyObject)runtime.newFixnum(29));
        _X509.setConstant("V_ERR_AKID_SKID_MISMATCH", (IRubyObject)runtime.newFixnum(30));
        _X509.setConstant("V_ERR_AKID_ISSUER_SERIAL_MISMATCH", (IRubyObject)runtime.newFixnum(31));
        _X509.setConstant("V_ERR_KEYUSAGE_NO_CERTSIGN", (IRubyObject)runtime.newFixnum(32));
        _X509.setConstant("V_ERR_APPLICATION_VERIFICATION", (IRubyObject)runtime.newFixnum(50));
        _X509.setConstant("V_FLAG_CRL_CHECK", (IRubyObject)_4);
        _X509.setConstant("V_FLAG_CRL_CHECK_ALL", (IRubyObject)_8);
        _X509.setConstant("PURPOSE_SSL_CLIENT", (IRubyObject)_1);
        _X509.setConstant("PURPOSE_SSL_SERVER", (IRubyObject)_2);
        _X509.setConstant("PURPOSE_NS_SSL_SERVER", (IRubyObject)_3);
        _X509.setConstant("PURPOSE_SMIME_SIGN", (IRubyObject)_4);
        _X509.setConstant("PURPOSE_SMIME_ENCRYPT", (IRubyObject)_5);
        _X509.setConstant("PURPOSE_CRL_SIGN", (IRubyObject)_6);
        _X509.setConstant("PURPOSE_ANY", (IRubyObject)_7);
        _X509.setConstant("PURPOSE_OCSP_HELPER", (IRubyObject)_8);
        _X509.setConstant("TRUST_COMPAT", (IRubyObject)_1);
        _X509.setConstant("TRUST_SSL_CLIENT", (IRubyObject)_2);
        _X509.setConstant("TRUST_SSL_SERVER", (IRubyObject)_3);
        _X509.setConstant("TRUST_EMAIL", (IRubyObject)_4);
        _X509.setConstant("TRUST_OBJECT_SIGN", (IRubyObject)_5);
        _X509.setConstant("TRUST_OCSP_SIGN", (IRubyObject)_6);
        _X509.setConstant("TRUST_OCSP_REQUEST", (IRubyObject)_7);
        _X509.setConstant("DEFAULT_CERT_AREA", (IRubyObject)runtime.newString(X509Utils.X509_CERT_AREA));
        _X509.setConstant("DEFAULT_CERT_DIR", (IRubyObject)runtime.newString(X509Utils.X509_CERT_DIR));
        _X509.setConstant("DEFAULT_CERT_FILE", (IRubyObject)runtime.newString(X509Utils.X509_CERT_FILE));
        _X509.setConstant("DEFAULT_CERT_DIR_ENV", (IRubyObject)runtime.newString("SSL_CERT_DIR"));
        _X509.setConstant("DEFAULT_CERT_FILE_ENV", (IRubyObject)runtime.newString("SSL_CERT_FILE"));
        _X509.setConstant("DEFAULT_PRIVATE_DIR", (IRubyObject)runtime.newString(X509Utils.X509_PRIVATE_DIR));
    }

    static RubyModule _X509(Ruby runtime) {
        return (RubyModule)runtime.getModule("OpenSSL").getConstant("X509");
    }

    static Map<Integer, String> getErrors() {
        return X509Error.getErrors();
    }
}

