/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.nodes;

import com.oracle.truffle.api.nodes.Node;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public abstract class NodeFieldAccessor {
    private static final boolean USE_UNSAFE = Boolean.getBoolean("truffle.unsafe");
    private final NodeFieldKind kind;
    private final Class<?> declaringClass;
    private final String name;
    protected final Class<?> type;

    protected NodeFieldAccessor(NodeFieldKind kind, Class<?> declaringClass, String name, Class<?> type) {
        this.kind = kind;
        this.declaringClass = declaringClass;
        this.name = name;
        this.type = type;
    }

    protected static NodeFieldAccessor create(NodeFieldKind kind, Field field) {
        if (USE_UNSAFE) {
            return new UnsafeNodeField(kind, field);
        }
        return new ReflectionNodeField(kind, field);
    }

    public NodeFieldKind getKind() {
        return this.kind;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public abstract void putObject(Node var1, Object var2);

    public abstract Object getObject(Node var1);

    public abstract Object loadValue(Node var1);

    private static final class ReflectionNodeField
    extends NodeFieldAccessor {
        private final Field field;

        protected ReflectionNodeField(NodeFieldKind kind, Field field) {
            super(kind, field.getDeclaringClass(), field.getName(), field.getType());
            this.field = field;
            field.setAccessible(true);
        }

        @Override
        public void putObject(Node receiver, Object value) {
            assert (!this.type.isPrimitive() && value == null || this.type.isInstance(value));
            try {
                this.field.set(receiver, value);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public Object getObject(Node receiver) {
            assert (!this.type.isPrimitive());
            try {
                return this.field.get(receiver);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public Object loadValue(Node node) {
            try {
                if (this.type == Boolean.TYPE) {
                    return this.field.getBoolean(node);
                }
                if (this.type == Byte.TYPE) {
                    return this.field.getByte(node);
                }
                if (this.type == Short.TYPE) {
                    return this.field.getShort(node);
                }
                if (this.type == Character.TYPE) {
                    return Character.valueOf(this.field.getChar(node));
                }
                if (this.type == Integer.TYPE) {
                    return this.field.getInt(node);
                }
                if (this.type == Long.TYPE) {
                    return this.field.getLong(node);
                }
                if (this.type == Float.TYPE) {
                    return Float.valueOf(this.field.getFloat(node));
                }
                if (this.type == Double.TYPE) {
                    return this.field.getDouble(node);
                }
                return this.field.get(node);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private static final class UnsafeNodeField
    extends AbstractUnsafeNodeFieldAccessor {
        private final long offset;

        protected UnsafeNodeField(NodeFieldKind kind, Field field) {
            super(kind, field.getDeclaringClass(), field.getName(), field.getType());
            this.offset = AbstractUnsafeNodeFieldAccessor.unsafe.objectFieldOffset(field);
        }

        @Override
        public long getOffset() {
            return this.offset;
        }
    }

    public static abstract class AbstractUnsafeNodeFieldAccessor
    extends NodeFieldAccessor {
        private static final Unsafe unsafe = AbstractUnsafeNodeFieldAccessor.getUnsafe();

        protected AbstractUnsafeNodeFieldAccessor(NodeFieldKind kind, Class<?> declaringClass, String name, Class<?> type) {
            super(kind, declaringClass, name, type);
        }

        public abstract long getOffset();

        @Override
        public void putObject(Node receiver, Object value) {
            if ((this.type.isPrimitive() || value != null) && !this.type.isInstance(value)) {
                throw new IllegalArgumentException();
            }
            unsafe.putObject(receiver, this.getOffset(), value);
        }

        @Override
        public Object getObject(Node receiver) {
            if (!this.type.isPrimitive()) {
                return unsafe.getObject(receiver, this.getOffset());
            }
            throw new IllegalArgumentException();
        }

        @Override
        public Object loadValue(Node node) {
            if (this.type == Boolean.TYPE) {
                return unsafe.getBoolean(node, this.getOffset());
            }
            if (this.type == Byte.TYPE) {
                return unsafe.getByte(node, this.getOffset());
            }
            if (this.type == Short.TYPE) {
                return unsafe.getShort(node, this.getOffset());
            }
            if (this.type == Character.TYPE) {
                return Character.valueOf(unsafe.getChar(node, this.getOffset()));
            }
            if (this.type == Integer.TYPE) {
                return unsafe.getInt(node, this.getOffset());
            }
            if (this.type == Long.TYPE) {
                return unsafe.getLong(node, this.getOffset());
            }
            if (this.type == Float.TYPE) {
                return Float.valueOf(unsafe.getFloat(node, this.getOffset()));
            }
            if (this.type == Double.TYPE) {
                return unsafe.getDouble(node, this.getOffset());
            }
            return unsafe.getObject(node, this.getOffset());
        }

        private static Unsafe getUnsafe() {
            try {
                return Unsafe.getUnsafe();
            }
            catch (SecurityException securityException) {
                try {
                    Field theUnsafeInstance = Unsafe.class.getDeclaredField("theUnsafe");
                    theUnsafeInstance.setAccessible(true);
                    return (Unsafe)theUnsafeInstance.get(Unsafe.class);
                }
                catch (Exception e) {
                    throw new RuntimeException("exception while trying to get Unsafe.theUnsafe via reflection:", e);
                }
            }
        }
    }

    public static enum NodeFieldKind {
        NODE_CLASS,
        PARENT,
        CHILD,
        CHILDREN,
        DATA;

    }
}

