/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.debug.shell.server;

import com.oracle.truffle.api.instrumentation.InstrumentableFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeClass;
import com.oracle.truffle.api.nodes.NodeFieldAccessor;
import com.oracle.truffle.api.source.SourceSection;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;

final class InstrumentationUtils {
    private InstrumentationUtils() {
    }

    static class LocationPrinter {
        LocationPrinter() {
        }

        public String displaySourceLocation(Node node) {
            if (node == null) {
                return "<unknown>";
            }
            SourceSection section = node.getSourceSection();
            boolean estimated = false;
            if (section == null) {
                section = node.getEncapsulatingSourceSection();
                estimated = true;
            }
            if (section == null) {
                return "<unknown source location>";
            }
            return section.getShortDescription() + (estimated ? "~" : "");
        }
    }

    static class ASTPrinter {
        ASTPrinter() {
        }

        public void printTree(PrintWriter p, Node node, int maxDepth, Node markNode) {
            this.printTree(p, node, maxDepth, markNode, 1);
            p.println();
            p.flush();
        }

        public String displayAST(Node node, int maxDepth, Node markNode) {
            StringWriter out = new StringWriter();
            this.printTree(new PrintWriter(out), node, maxDepth, markNode);
            return out.toString();
        }

        public String displayAST(Node node, int maxDepth) {
            return this.displayAST(node, maxDepth, null);
        }

        public String displayNodeWithInstrumentation(Node node) {
            if (node == null) {
                return "null";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.displayNodeName(node));
            sb.append("(");
            sb.append(this.displayTags(node));
            if (node.getParent() instanceof InstrumentableFactory.WrapperNode) {
                sb.append(",Probed");
            }
            sb.append(") ");
            sb.append(this.displaySourceInfo(node));
            return sb.toString();
        }

        protected String displayTags(Object node) {
            if (node instanceof Node && ((Node)node).getSourceSection() != null) {
                return ((Node)node).getSourceSection().toString();
            }
            return "";
        }

        protected void printTree(PrintWriter p, Node node, int maxDepth, Node markNode, int level) {
            if (node == null) {
                p.print("null");
                return;
            }
            if (node instanceof InstrumentableFactory.WrapperNode) {
                p.print("WRAPPER(" + node.getClass().getSimpleName() + ")");
            } else {
                p.print(this.displayNodeWithInstrumentation(node));
            }
            if (level <= maxDepth) {
                ArrayList<NodeFieldAccessor> childFields = new ArrayList<NodeFieldAccessor>();
                for (NodeFieldAccessor field : NodeClass.get(node).getFields()) {
                    if (field.getKind() != NodeFieldAccessor.NodeFieldKind.CHILD && field.getKind() != NodeFieldAccessor.NodeFieldKind.CHILDREN) continue;
                    childFields.add(field);
                }
                if (childFields.size() != 0) {
                    p.print(" {");
                    for (NodeFieldAccessor field : childFields) {
                        Object value = field.loadValue(node);
                        if (value == null) {
                            this.printNewLine(p, level);
                            p.print(field.getName());
                            p.print(" = null ");
                            continue;
                        }
                        if (field.getKind() == NodeFieldAccessor.NodeFieldKind.CHILD) {
                            this.printChild(p, maxDepth, markNode, level, field, value);
                            continue;
                        }
                        if (field.getKind() == NodeFieldAccessor.NodeFieldKind.CHILDREN) {
                            this.printChildren(p, maxDepth, markNode, level, field, value);
                            continue;
                        }
                        this.printNewLine(p, level);
                        p.print(field.getName());
                    }
                    this.printNewLine(p, level - 1);
                    p.print("}");
                }
            }
        }

        protected void printChildren(PrintWriter p, int maxDepth, Node markNode, int level, NodeFieldAccessor field, Object value) {
            this.printNewLine(p, level);
            p.print(field.getName());
            Node[] children = (Node[])value;
            p.print(" = [");
            String sep = "";
            for (Node child : children) {
                p.print(sep);
                sep = ", ";
                this.printTree(p, child, maxDepth, markNode, level + 1);
            }
            p.print("]");
        }

        protected void printChild(PrintWriter p, int maxDepth, Node markNode, int level, NodeFieldAccessor field, Object value) {
            Node valueNode = (Node)value;
            this.printNewLine(p, level, valueNode == markNode);
            p.print(field.getName());
            p.print(" = ");
            this.printTree(p, valueNode, maxDepth, markNode, level + 1);
        }

        protected void printNewLine(PrintWriter p, int level, boolean mark) {
            p.println();
            for (int i = 0; i < level; ++i) {
                if (mark && i == 0) {
                    p.print(" -->");
                    continue;
                }
                p.print("    ");
            }
        }

        protected void printNewLine(PrintWriter p, int level) {
            this.printNewLine(p, level, false);
        }

        protected String displayNodeName(Node node) {
            return node.getClass().getSimpleName();
        }

        protected String displaySourceInfo(Node node) {
            SourceSection src = node.getSourceSection();
            if (src != null) {
                if (src.getSource() == null) {
                    return src.getShortDescription();
                }
                return src.getSource().getName() + ":" + src.getStartLine();
            }
            return "";
        }
    }
}

