/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.module.ModuleNodes;
import org.jruby.truffle.core.module.ModuleNodesFactory;

@CoreClass(value="main")
public abstract class MainNodes {

    @CoreMethod(names={"private"}, rest=true, needsSelf=false, visibility=Visibility.PRIVATE)
    public static abstract class PrivateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ModuleNodes.PrivateNode privateNode;

        public PrivateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.privateNode = ModuleNodesFactory.PrivateNodeFactory.create(context, sourceSection, null);
        }

        @Specialization
        public DynamicObject doPrivate(VirtualFrame frame, Object[] args) {
            DynamicObject object = this.coreLibrary().getObjectClass();
            return this.privateNode.executePrivate(frame, object, args);
        }
    }

    @CoreMethod(names={"public"}, rest=true, needsSelf=false, visibility=Visibility.PRIVATE)
    public static abstract class PublicNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ModuleNodes.PublicNode publicNode;

        public PublicNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.publicNode = ModuleNodesFactory.PublicNodeFactory.create(context, sourceSection, null);
        }

        @Specialization
        public DynamicObject doPublic(VirtualFrame frame, Object[] args) {
            DynamicObject object = this.coreLibrary().getObjectClass();
            return this.publicNode.executePublic(frame, object, args);
        }
    }
}

