/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.compiled;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.psi.compiled.ClsStubBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassFileDecompilers {
    public static final ExtensionPointName<Decompiler> EP_NAME = ExtensionPointName.create("com.intellij.psi.classFileDecompiler");

    private ClassFileDecompilers() {
    }

    @Nullable
    public static Decompiler find(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/compiled/ClassFileDecompilers", "find"));
        }
        for (Decompiler decompiler : EP_NAME.getExtensions()) {
            if (!(decompiler instanceof Light) && !(decompiler instanceof Full) || !decompiler.accepts(file)) continue;
            return decompiler;
        }
        return null;
    }

    public static abstract class Full
    implements Decompiler {
        @NotNull
        public abstract ClsStubBuilder getStubBuilder();

        @NotNull
        public abstract FileViewProvider createFileViewProvider(@NotNull VirtualFile var1, @NotNull PsiManager var2, boolean var3);
    }

    public static abstract class Light
    implements Decompiler {
        @NotNull
        public abstract CharSequence getText(@NotNull VirtualFile var1) throws CannotDecompileException;

        public static class CannotDecompileException
        extends RuntimeException {
            public CannotDecompileException(String message) {
                super(message);
            }

            public CannotDecompileException(Throwable cause) {
                super(cause);
            }
        }
    }

    public static interface Decompiler {
        public boolean accepts(@NotNull VirtualFile var1);
    }
}

