/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.util.List;
import opennlp.tools.util.StringUtil;
import opennlp.tools.util.featuregen.FeatureGeneratorAdapter;
import opennlp.tools.util.featuregen.FeatureGeneratorUtil;

public class TokenClassFeatureGenerator
extends FeatureGeneratorAdapter {
    private static final String TOKEN_CLASS_PREFIX = "wc";
    private static final String TOKEN_AND_CLASS_PREFIX = "w&c";
    private boolean generateWordAndClassFeature;

    public TokenClassFeatureGenerator() {
        this(false);
    }

    public TokenClassFeatureGenerator(boolean genearteWordAndClassFeature) {
        this.generateWordAndClassFeature = genearteWordAndClassFeature;
    }

    @Override
    public void createFeatures(List<String> features, String[] tokens, int index, String[] preds) {
        String wordClass = FeatureGeneratorUtil.tokenFeature(tokens[index]);
        features.add("wc=" + wordClass);
        if (this.generateWordAndClassFeature) {
            features.add("w&c=" + StringUtil.toLowerCase(tokens[index]) + "," + wordClass);
        }
    }
}

