/*
 * Decompiled with CFR 0.152.
 */
package org.ictclas4j.bean;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.ictclas4j.bean.ContextStat;
import org.ictclas4j.bean.Dictionary;
import org.ictclas4j.bean.WordItem;
import org.ictclas4j.bean.WordResult;
import org.ictclas4j.utility.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Span {
    public ContextStat context;
    Utility.TAG_TYPE tagType;
    private int[][] m_nTags = new int[120][20];
    int[][] m_nBestPrev;
    int m_nStartPos;
    int[] m_nBestTag;
    int m_nCurLength;
    String[] m_sWords;
    double[][] m_dFrequency;
    public int[][] m_nUnknownWords;
    public int m_nUnknownIndex;
    public int[] m_nWordPosition;
    public double[] m_dWordsPossibility;

    public Span() {
        this.m_nTags[0][0] = this.tagType != Utility.TAG_TYPE.TT_NORMAL ? 100 : 0;
        this.m_nTags[0][1] = -1;
        this.m_nBestPrev = new int[120][20];
        this.m_nBestTag = new int[120];
        this.m_sWords = new String[120];
        this.m_nUnknownWords = new int[200][2];
        this.m_nWordPosition = new int[120];
        this.m_dWordsPossibility = new double[200];
        this.m_dFrequency = new double[120][20];
        this.tagType = Utility.TAG_TYPE.TT_NORMAL;
    }

    public boolean loadContext(String fileName) {
        if (fileName != null) {
            this.context = new ContextStat();
            return this.context.load(fileName);
        }
        return false;
    }

    public void setType(Utility.TAG_TYPE type) {
        this.tagType = type;
    }

    public boolean posTagging(ArrayList<WordResult> wrList, Dictionary coreDict, Dictionary unknownDict) {
        int i = 0;
        this.reset(false);
        while (i > -1 && i < wrList.size()) {
            int nStartPos = i;
            i = this.getFrom(wrList, nStartPos, coreDict, unknownDict);
            this.getBestPOS();
            switch (this.tagType) {
                case TT_NORMAL: {
                    for (int j = 1; this.m_nBestTag[j] != -1 && j < this.m_nCurLength; ++j) {
                        WordResult wr = wrList.get(j + nStartPos - 1);
                        wr.setHandle(this.m_nBestTag[j]);
                        if (!(wr.getValue() > 0.0) || !coreDict.isExist(wr.getWord(), -1)) continue;
                        wr.setValue(coreDict.getFreq(wr.getWord(), this.m_nBestTag[j]));
                    }
                    break;
                }
                case TT_PERSON: {
                    this.PersonRecognize(unknownDict);
                    break;
                }
                case TT_PLACE: 
                case TT_TRANS_PERSON: {
                    this.PlaceRecognize(coreDict, unknownDict);
                    break;
                }
            }
            this.reset();
        }
        return true;
    }

    public boolean reset(boolean isContinue) {
        if (!isContinue) {
            this.m_nTags[0][0] = this.tagType != Utility.TAG_TYPE.TT_NORMAL ? 100 : 0;
            this.m_nUnknownIndex = 0;
            this.m_dFrequency[0][0] = 0.0;
            this.m_nStartPos = 0;
        } else {
            this.m_nTags[0][0] = this.m_nTags[this.m_nCurLength - 1][0];
            this.m_dFrequency[0][0] = this.m_dFrequency[this.m_nCurLength - 1][0];
        }
        this.m_nTags[0][1] = -1;
        this.m_nCurLength = 1;
        this.m_nWordPosition[1] = this.m_nStartPos;
        this.m_sWords[0] = null;
        return true;
    }

    public boolean reset() {
        return this.reset(true);
    }

    private boolean disamb() {
        double dMinFee = 0.0;
        double dTmp = 0.0;
        for (int i = 1; i < this.m_nCurLength; ++i) {
            int j = 0;
            while (this.m_nTags[i][j] >= 0) {
                int nMinCandidate = 21;
                int k = 0;
                while (this.m_nTags[i - 1][k] >= 0) {
                    dTmp = -Math.log(this.context.getPossibility(0, this.m_nTags[i - 1][k], this.m_nTags[i][j]));
                    dTmp += this.m_dFrequency[i - 1][k];
                    if (nMinCandidate > 10 || dTmp < dMinFee) {
                        nMinCandidate = k;
                        dMinFee = dTmp;
                    }
                    ++k;
                }
                this.m_nBestPrev[i][j] = nMinCandidate;
                this.m_dFrequency[i][j] = this.m_dFrequency[i][j] + dMinFee;
                ++j;
            }
        }
        return true;
    }

    public boolean getBestPOS() {
        this.disamb();
        int j = 0;
        for (int i = this.m_nCurLength - 1; i > 0; --i) {
            if (this.m_sWords[i] != null) {
                this.m_nBestTag[i] = this.m_nTags[i][j];
            }
            j = this.m_nBestPrev[i][j];
        }
        int nEnd = this.m_nCurLength;
        if (this.m_sWords[this.m_nCurLength - 1] == null) {
            nEnd = this.m_nCurLength - 1;
        }
        this.m_nBestTag[nEnd] = -1;
        return true;
    }

    public int getFrom(ArrayList<WordResult> wrList, int index, Dictionary coreDict, Dictionary unknownDict) {
        int i;
        int[] aPOS = new int[20];
        int[] aFreq = new int[20];
        int nFreq = 0;
        int nRetPos = 0;
        int nWordsIndex = 0;
        boolean bSplit = false;
        nWordsIndex = index;
        for (i = 1; i < 120 && nWordsIndex < wrList.size(); ++i) {
            int j;
            block22: {
                int nPOSCount;
                ArrayList<WordItem> wis;
                WordResult wr;
                block20: {
                    block23: {
                        block21: {
                            wr = wrList.get(nWordsIndex);
                            String word = wr.getWord();
                            if (this.tagType == Utility.TAG_TYPE.TT_NORMAL || !unknownDict.isExist(word, 44)) {
                                this.m_sWords[i] = word;
                                try {
                                    this.m_nWordPosition[i + 1] = this.m_nWordPosition[i] + this.m_sWords[i].getBytes("GBK").length;
                                }
                                catch (UnsupportedEncodingException e) {
                                    e.printStackTrace();
                                    this.m_nWordPosition[i + 1] = this.m_nWordPosition[i] + this.m_sWords[i].getBytes().length;
                                }
                            }
                            this.m_nStartPos = this.m_nWordPosition[i + 1];
                            if (this.tagType == Utility.TAG_TYPE.TT_NORMAL) break block20;
                            String sCurWord = this.m_sWords[i];
                            if (this.tagType == Utility.TAG_TYPE.TT_TRANS_PERSON && i > 0 && Utility.charType(this.m_sWords[i - 1]) == 7) {
                                if (".".equals(this.m_sWords[i])) {
                                    sCurWord = "\uff0e";
                                } else if ("-".equals(this.m_sWords)) {
                                    sCurWord = "\uff0d";
                                }
                            }
                            wis = unknownDict.getHandle(sCurWord);
                            nPOSCount = wis.size() + 1;
                            for (j = 0; j < wis.size(); ++j) {
                                aPOS[j] = wis.get(j).getHandle();
                                aFreq[j] = wis.get(j).getFreq();
                                this.m_nTags[i][j] = aPOS[j];
                                this.m_dFrequency[i][j] = -Math.log(1 + aFreq[j]);
                                double[] dArray = this.m_dFrequency[i];
                                int n = j;
                                dArray[n] = dArray[n] + Math.log(this.context.getFreq(0, aPOS[j]) + nPOSCount);
                            }
                            if (!"\u59cb##\u59cb".equals(this.m_sWords[i])) break block21;
                            this.m_nTags[i][j] = 100;
                            this.m_dFrequency[i][j] = 0.0;
                            ++j;
                            break block22;
                        }
                        if (!"\u672b##\u672b".equals(this.m_sWords[i])) break block23;
                        this.m_nTags[i][j] = 101;
                        this.m_dFrequency[i][j] = 0.0;
                        ++j;
                        break block22;
                    }
                    wis = coreDict.getHandle(this.m_sWords[i]);
                    nFreq = 0;
                    for (int k = 0; k < wis.size(); ++k) {
                        aFreq[k] = wis.get(k).getFreq();
                        nFreq += aFreq[k];
                    }
                    if (wis.size() <= 0) break block22;
                    this.m_nTags[i][j] = 0;
                    this.m_dFrequency[i][j] = -Math.log(1 + nFreq);
                    double[] dArray = this.m_dFrequency[i];
                    int n = j++;
                    dArray[n] = dArray[n] + Math.log(this.context.getFreq(0, 0) + nPOSCount);
                    break block22;
                }
                j = 0;
                if (wr.getHandle() > 0) {
                    this.m_nTags[i][j] = wr.getHandle();
                    this.m_dFrequency[i][j] = -Math.log(wr.getValue()) + Math.log(this.context.getFreq(0, this.m_nTags[i][j]) + 1);
                    if (this.m_dFrequency[i][j] < 0.0) {
                        this.m_dFrequency[i][j] = 0.0;
                    }
                    ++j;
                } else {
                    if (wr.getHandle() < 0) {
                        this.m_nTags[i][j] = -wr.getHandle();
                        this.m_dFrequency[i][j++] = wr.getValue();
                    }
                    wis = coreDict.getHandle(this.m_sWords[i]);
                    nPOSCount = wis.size();
                    while (j < wis.size()) {
                        aPOS[j] = wis.get(j).getHandle();
                        aFreq[j] = wis.get(j).getFreq();
                        this.m_nTags[i][j] = aPOS[j];
                        this.m_dFrequency[i][j] = -Math.log(1 + aFreq[j]) + Math.log(this.context.getFreq(0, this.m_nTags[i][j]) + nPOSCount);
                        ++j;
                    }
                }
            }
            if (j == 0) {
                j = this.guessPOS(i);
            }
            this.m_nTags[i][j] = -1;
            if (j == 1 && this.m_nTags[i][j] != 1) {
                this.m_sWords[++i] = null;
                break;
            }
            if (bSplit) continue;
            ++nWordsIndex;
        }
        if (nWordsIndex == wrList.size()) {
            nRetPos = -1;
        }
        if (this.m_nTags[i - 1][1] != -1) {
            this.m_nTags[i][0] = this.tagType != Utility.TAG_TYPE.TT_NORMAL ? 101 : 1;
            this.m_dFrequency[i][0] = 0.0;
            this.m_sWords[i] = null;
            this.m_nTags[i++][1] = -1;
        }
        this.m_nCurLength = i;
        if (nRetPos != -1) {
            return nWordsIndex + 1;
        }
        return -1;
    }

    public boolean PersonRecognize(Dictionary personDict) {
        String sPOS = "z";
        String[] patterns = new String[]{"BBCD", "BBC", "BBE", "BBZ", "BCD", "BEE", "BE", "BG", "BXD", "BZ", "CDCD", "CD", "EE", "FB", "Y", "XD", ""};
        double[] factor = new double[]{0.003606, 2.1E-5, 0.001314, 3.15E-4, 0.656624, 2.1E-5, 0.146116, 0.009136, 4.2E-5, 0.038971, 0.0, 0.090367, 2.73E-4, 0.009157, 0.034324, 0.009735, 0.0};
        int[] patternLen = new int[]{4, 3, 3, 3, 3, 3, 2, 2, 3, 2, 4, 2, 2, 2, 1, 2, 0};
        int i = 0;
        i = 1;
        while (this.m_nBestTag[i] > -1) {
            sPOS = sPOS + (char)(this.m_nBestTag[i] + 65);
            ++i;
        }
        int j = 1;
        boolean bMatched = false;
        while (j < i) {
            bMatched = false;
            int k = 0;
            while (!bMatched && patternLen[k] > 0) {
                if (sPOS.substring(j).indexOf(patterns[k]) == 0 && !"\u00b7".equals(this.m_sWords[j - 1]) && !"\u00b7".equals(this.m_sWords[j + patternLen[k]])) {
                    String temp = sPOS.substring(j + 2);
                    if (temp.length() > 1) {
                        temp = temp.substring(0, 1);
                    }
                    if (!"FB".equals(patterns[k]) || !"E".equals(temp) && !"C".equals(temp) && !"G".equals(temp)) {
                        String sPersonName = "";
                        int nLittleFreqCount = 0;
                        for (int nPos = j; nPos < j + patternLen[k]; ++nPos) {
                            if (this.m_nBestTag[nPos] < 4 && personDict.getFreq(this.m_sWords[nPos], this.m_nBestTag[nPos]) < 6) {
                                ++nLittleFreqCount;
                            }
                            sPersonName = sPersonName + this.m_sWords[nPos];
                        }
                        if ("CDCD".equals(patterns[k])) {
                            if (this.GetForeignCharCount(sPersonName) > 0) {
                                j += patternLen[k] - 1;
                            }
                        } else {
                            this.m_nUnknownWords[this.m_nUnknownIndex][0] = this.m_nWordPosition[j];
                            this.m_nUnknownWords[this.m_nUnknownIndex][1] = this.m_nWordPosition[j + patternLen[k]];
                            this.m_dWordsPossibility[this.m_nUnknownIndex] = -Math.log(factor[k]) + this.ComputePossibility(j, patternLen[k], personDict);
                            ++this.m_nUnknownIndex;
                            j += patternLen[k];
                            bMatched = true;
                        }
                    }
                }
                ++k;
            }
            if (bMatched) continue;
            ++j;
        }
        return true;
    }

    private int guessPOS(int index) {
        int j = 0;
        int i = index;
        switch (this.tagType) {
            case TT_NORMAL: {
                break;
            }
            case TT_PERSON: {
                int nLen;
                j = 0;
                if (this.m_sWords[index].indexOf("\u00d7\u00d7") != -1) {
                    this.m_nTags[i][j] = 6;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 6) + 1);
                    break;
                }
                this.m_nTags[i][j] = 0;
                this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 0) + 1);
                try {
                    nLen = this.m_sWords[index].getBytes("GBK").length;
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    nLen = this.m_sWords[index].getBytes().length;
                }
                if (nLen >= 4) {
                    this.m_nTags[i][j] = 0;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 0) + 1);
                    this.m_nTags[i][j] = 11;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 11) * 8);
                    this.m_nTags[i][j] = 12;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 12) * 8);
                    this.m_nTags[i][j] = 13;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 13) * 8);
                    break;
                }
                if (nLen != 2) break;
                this.m_nTags[i][j] = 0;
                this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 0) + 1);
                int charType = Utility.charType(this.m_sWords[index]);
                if (charType == 17 || charType == 7) {
                    this.m_nTags[i][j] = 1;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 1) + 1);
                    this.m_nTags[i][j] = 2;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 2) + 1);
                    this.m_nTags[i][j] = 3;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 3) + 1);
                    this.m_nTags[i][j] = 4;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 4) + 1);
                }
                this.m_nTags[i][j] = 11;
                this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 11) * 8);
                this.m_nTags[i][j] = 12;
                this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 12) * 8);
                this.m_nTags[i][j] = 13;
                this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 13) * 8);
                break;
            }
            case TT_PLACE: {
                j = 0;
                this.m_nTags[i][j] = 0;
                this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 0) + 1);
                int nLen = this.m_sWords[index].length();
                if (nLen >= 4) {
                    this.m_nTags[i][j] = 11;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 11) * 8);
                    this.m_nTags[i][j] = 12;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 12) * 8);
                    this.m_nTags[i][j] = 13;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 13) * 8);
                    break;
                }
                if (nLen != 2) break;
                this.m_nTags[i][j] = 0;
                this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 0) + 1);
                int charType = Utility.charType(this.m_sWords[index]);
                if (charType == 17 || charType == 7) {
                    this.m_nTags[i][j] = 1;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 1) + 1);
                    this.m_nTags[i][j] = 2;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 2) + 1);
                    this.m_nTags[i][j] = 3;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 3) + 1);
                    this.m_nTags[i][j] = 4;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 4) + 1);
                }
                this.m_nTags[i][j] = 11;
                this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 11) * 8);
                this.m_nTags[i][j] = 12;
                this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 12) * 8);
                this.m_nTags[i][j] = 13;
                this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 13) * 8);
                break;
            }
            case TT_TRANS_PERSON: {
                j = 0;
                int nLen = this.m_sWords[index].length();
                this.m_nTags[i][j] = 0;
                this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 0) + 1);
                if (!Utility.isAllChinese(this.m_sWords[index])) {
                    if (Utility.isAllLetter(this.m_sWords[index])) {
                        this.m_nTags[i][j] = 1;
                        this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 1) + 1);
                        this.m_nTags[i][j] = 11;
                        this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 11) + 1);
                        this.m_nTags[i][j] = 2;
                        this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 2) * 2 + 1);
                        this.m_nTags[i][j] = 3;
                        this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 3) * 2 + 1);
                        this.m_nTags[i][j] = 12;
                        this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 12) * 2 + 1);
                        this.m_nTags[i][j] = 13;
                        this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 13) * 2 + 1);
                    }
                    this.m_nTags[i][j] = 41;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 41) * 8);
                    this.m_nTags[i][j] = 42;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 42) * 8);
                    this.m_nTags[i][j] = 43;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 43) * 8);
                    break;
                }
                if (nLen >= 4) {
                    this.m_nTags[i][j] = 41;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 41) * 8);
                    this.m_nTags[i][j] = 42;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 42) * 8);
                    this.m_nTags[i][j] = 43;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 43) * 8);
                    break;
                }
                if (nLen != 2) break;
                int charType = Utility.charType(this.m_sWords[index]);
                if (charType == 17 || charType == 7) {
                    this.m_nTags[i][j] = 1;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 1) * 2 + 1);
                    this.m_nTags[i][j] = 2;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 2) * 2 + 1);
                    this.m_nTags[i][j] = 3;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 3) * 2 + 1);
                    this.m_nTags[i][j] = 30;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 30) * 8 + 1);
                    this.m_nTags[i][j] = 11;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 11) * 4 + 1);
                    this.m_nTags[i][j] = 12;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 12) * 4 + 1);
                    this.m_nTags[i][j] = 13;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 13) * 4 + 1);
                    this.m_nTags[i][j] = 21;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 21) * 2 + 1);
                    this.m_nTags[i][j] = 22;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 22) * 2 + 1);
                    this.m_nTags[i][j] = 23;
                    this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 23) * 2 + 1);
                }
                this.m_nTags[i][j] = 41;
                this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 41) * 8);
                this.m_nTags[i][j] = 42;
                this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 42) * 8);
                this.m_nTags[i][j] = 43;
                this.m_dFrequency[i][j++] = 1.0 / (double)(this.context.getFreq(0, 43) * 8);
                break;
            }
        }
        return j;
    }

    int GetForeignCharCount(String personName) {
        return 0;
    }

    public boolean PlaceRecognize(Dictionary coreDict, Dictionary placeDict) {
        int nStart = 1;
        int nEnd = 1;
        int i = 1;
        double dPanelty = 1.0;
        while (this.m_nBestTag[i] > -1) {
            int nTemp;
            if (this.m_nBestTag[i] == 1) {
                nStart = i;
                nEnd = nStart + 1;
                while (this.m_nBestTag[nEnd] == 1) {
                    if (nEnd > nStart + 1) {
                        dPanelty += 1.0;
                    }
                    ++nEnd;
                }
                while (this.m_nBestTag[nEnd] == 2) {
                    ++nEnd;
                }
                nTemp = nEnd;
                while (this.m_nBestTag[nEnd] == 3) {
                    if (nEnd > nTemp) {
                        dPanelty += 1.0;
                    }
                    ++nEnd;
                }
            } else if (this.m_nBestTag[i] == 2) {
                dPanelty += 1.0;
                nStart = i;
                nEnd = nStart + 1;
                while (this.m_nBestTag[nEnd] == 2) {
                    ++nEnd;
                }
                nTemp = nEnd;
                while (this.m_nBestTag[nEnd] == 3) {
                    if (nEnd > nTemp) {
                        dPanelty += 1.0;
                    }
                    ++nEnd;
                }
            }
            if (nEnd > nStart) {
                this.m_nUnknownWords[this.m_nUnknownIndex][0] = this.m_nWordPosition[nStart];
                this.m_nUnknownWords[this.m_nUnknownIndex][1] = this.m_nWordPosition[nEnd];
                this.m_dWordsPossibility[this.m_nUnknownIndex++] = this.ComputePossibility(nStart, nEnd - nStart + 1, placeDict) + Math.log(dPanelty);
                nStart = nEnd;
            }
            if (i < nEnd) {
                i = nEnd;
                continue;
            }
            ++i;
        }
        return true;
    }

    private double ComputePossibility(int startPos, int length, Dictionary dict) {
        double retValue = 0.0;
        for (int i = startPos; i < startPos + length; ++i) {
            int nFreq = dict.getFreq(this.m_sWords[i], this.m_nBestTag[i]);
            double posPoss = Math.log(this.context.getFreq(0, this.m_nBestTag[i]) + 1) - Math.log(nFreq + 1);
            retValue += posPoss;
        }
        return retValue;
    }
}

