/*
 * Decompiled with CFR 0.152.
 */
package writer2latex;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import writer2latex.BatchHandlerImpl;
import writer2latex.api.BatchConverter;
import writer2latex.api.Converter;
import writer2latex.api.ConverterFactory;
import writer2latex.api.ConverterResult;
import writer2latex.util.Misc;

public final class Application {
    private String sTargetMIME = "application/x-latex";
    private boolean bRecurse = false;
    private Vector<String> configFileNames = new Vector();
    private String sTemplateFileName = null;
    private String sStyleSheetFileName = null;
    private Set<String> resources = new HashSet<String>();
    private Hashtable<String, String> options = new Hashtable();
    private String sSource = null;
    private String sTarget = null;

    public static final void main(String[] args) {
        try {
            Application app = new Application();
            app.parseCommandLine(args);
            app.doConversion();
        }
        catch (IllegalArgumentException ex) {
            String msg = ex.getMessage();
            Application.showUsage(msg);
        }
    }

    private void doConversion() {
        File target;
        boolean bBatch;
        String sOutputFormat = "application/x-latex".equals(this.sTargetMIME) ? "LaTeX" : ("application/x-bibtex".equals(this.sTargetMIME) ? "BibTeX" : "xhtml");
        System.out.println();
        System.out.println("This is Writer2" + sOutputFormat + ", Version " + ConverterFactory.getVersion() + " (" + ConverterFactory.getDate() + ")");
        System.out.println();
        System.out.println("Starting conversion...");
        File source = new File(this.sSource);
        if (!source.exists()) {
            System.out.println("I'm sorry, I can't find " + this.sSource);
            System.exit(1);
        }
        if (!source.canRead()) {
            System.out.println("I'm sorry, I can't read " + this.sSource);
            System.exit(1);
        }
        if (bBatch = source.isDirectory()) {
            target = this.sTarget == null ? source : new File(this.sTarget);
        } else if (this.sTarget == null) {
            target = new File(source.getParent(), Misc.removeExtension(source.getName()));
        } else {
            target = new File(this.sTarget);
            if (this.sTarget.endsWith(File.separator)) {
                target = new File(target, Misc.removeExtension(source.getName()));
            }
        }
        Converter converter = ConverterFactory.createConverter(this.sTargetMIME);
        if (converter == null) {
            System.out.println("Failed to create converter for " + this.sTargetMIME);
            System.exit(1);
        }
        BatchConverter batchCv = null;
        if (bBatch) {
            batchCv = ConverterFactory.createBatchConverter("text/html");
            if (batchCv == null) {
                System.out.println("Failed to create batch converter");
                System.exit(1);
            }
            batchCv.setConverter(converter);
        }
        if (this.sTemplateFileName != null) {
            try {
                System.out.println("Reading template " + this.sTemplateFileName);
                byte[] templateBytes = Misc.inputStreamToByteArray(new FileInputStream(this.sTemplateFileName));
                converter.readTemplate(new ByteArrayInputStream(templateBytes));
                if (batchCv != null) {
                    batchCv.readTemplate(new ByteArrayInputStream(templateBytes));
                }
            }
            catch (FileNotFoundException e) {
                System.out.println("--> This file does not exist!");
                System.out.println("    " + e.getMessage());
            }
            catch (IOException e) {
                System.out.println("--> Failed to read the template file!");
                System.out.println("    " + e.getMessage());
            }
        }
        if (this.sStyleSheetFileName != null) {
            try {
                System.out.println("Reading style sheet " + this.sStyleSheetFileName);
                byte[] styleSheetBytes = Misc.inputStreamToByteArray(new FileInputStream(this.sStyleSheetFileName));
                converter.readStyleSheet(new ByteArrayInputStream(styleSheetBytes));
            }
            catch (FileNotFoundException e) {
                System.out.println("--> This file does not exist!");
                System.out.println("    " + e.getMessage());
            }
            catch (IOException e) {
                System.out.println("--> Failed to read the style sheet file!");
                System.out.println("    " + e.getMessage());
            }
        }
        for (String sResource : this.resources) {
            String sMediaType;
            String sFileName;
            int nSeparator = sResource.indexOf("::");
            if (nSeparator > -1) {
                sFileName = sResource.substring(0, nSeparator);
                sMediaType = sResource.substring(nSeparator + 2);
            } else {
                sFileName = sResource;
                sMediaType = null;
            }
            System.out.println("Reading resource file " + sFileName);
            try {
                byte[] resourceBytes = Misc.inputStreamToByteArray(new FileInputStream(sFileName));
                converter.readResource(new ByteArrayInputStream(resourceBytes), sFileName, sMediaType);
            }
            catch (IOException e) {
                System.out.println("--> Failed to read the resource file!");
                System.out.println("    " + e.getMessage());
            }
        }
        for (int i = 0; i < this.configFileNames.size(); ++i) {
            String sConfigFileName = this.configFileNames.get(i);
            if (sConfigFileName.startsWith("*")) {
                sConfigFileName = sConfigFileName.substring(1);
                System.out.println("Reading default configuration " + sConfigFileName);
                try {
                    converter.getConfig().readDefaultConfig(sConfigFileName);
                }
                catch (IllegalArgumentException e) {
                    System.err.println("--> This configuration is unknown!");
                    System.out.println("    " + e.getMessage());
                }
                continue;
            }
            System.out.println("Reading configuration file " + sConfigFileName);
            try {
                byte[] configBytes = Misc.inputStreamToByteArray(new FileInputStream(sConfigFileName));
                converter.getConfig().read(new ByteArrayInputStream(configBytes));
                if (!bBatch) continue;
                batchCv.getConfig().read(new ByteArrayInputStream(configBytes));
                continue;
            }
            catch (IOException e) {
                System.err.println("--> Failed to read the configuration!");
                System.out.println("    " + e.getMessage());
            }
        }
        Enumeration<String> keys = this.options.keys();
        while (keys.hasMoreElements()) {
            String sKey = keys.nextElement();
            String sValue = this.options.get(sKey);
            converter.getConfig().setOption(sKey, sValue);
            if (batchCv == null) continue;
            batchCv.getConfig().setOption(sKey, sValue);
        }
        if (bBatch) {
            batchCv.convert(source, target, this.bRecurse, new BatchHandlerImpl());
        } else {
            System.out.println("Converting " + source.getPath());
            ConverterResult dataOut = null;
            try {
                dataOut = converter.convert(source, target.getName());
            }
            catch (FileNotFoundException e) {
                System.out.println("--> The file " + source.getPath() + " does not exist!");
                System.out.println("    " + e.getMessage());
                System.exit(1);
            }
            catch (IOException e) {
                System.out.println("--> Failed to convert the file " + source.getPath() + "!");
                System.out.println("    " + e.getMessage());
                System.out.println("    Please make sure the file is in OpenDocument format");
                System.exit(1);
            }
            File targetDir = target.getParentFile();
            if (targetDir != null && !targetDir.exists()) {
                targetDir.mkdirs();
            }
            try {
                dataOut.write(targetDir);
            }
            catch (IOException e) {
                System.out.println("--> Error writing out file!");
                System.out.println("    " + e.getMessage());
                System.exit(1);
            }
        }
        System.out.println("Done!");
    }

    private static void showUsage(String msg) {
        System.out.println();
        System.out.println("This is Writer2LaTeX, Version " + ConverterFactory.getVersion() + " (" + ConverterFactory.getDate() + ")");
        System.out.println();
        if (msg != null) {
            System.out.println(msg);
        }
        System.out.println();
        System.out.println("Usage:");
        System.out.println("   java -jar <path>/writer2latex.jar <options> <source file/directory> [<target file/directory>]");
        System.out.println("where the available options are:");
        System.out.println("   -latex");
        System.out.println("   -bibtex");
        System.out.println("   -xhtml");
        System.out.println("   -xhtml11");
        System.out.println("   -xhtml+mathml");
        System.out.println("   -html5");
        System.out.println("   -epub");
        System.out.println("   -recurse");
        System.out.println("   -template[=]<template file>");
        System.out.println("   -stylesheet[=]<style sheet file>");
        System.out.println("   -resource[=]<resource file>[::<media type>]");
        System.out.println("   -ultraclean");
        System.out.println("   -clean");
        System.out.println("   -pdfprint");
        System.out.println("   -pdfscreen");
        System.out.println("   -cleanxhtml");
        System.out.println("   -config[=]<configuration file>");
        System.out.println("   -<configuration option>[=]<value>");
        System.out.println("See the documentation for the available configuration options");
    }

    private void parseCommandLine(String[] sArgs) throws IllegalArgumentException {
        int i = 0;
        while (i < sArgs.length) {
            String sArgument;
            String sArg;
            if ((sArg = this.getArg(i++, sArgs)).startsWith("-")) {
                String sArg2;
                if ("-latex".equals(sArg)) {
                    this.sTargetMIME = "application/x-latex";
                    continue;
                }
                if ("-bibtex".equals(sArg)) {
                    this.sTargetMIME = "application/x-bibtex";
                    continue;
                }
                if ("-html5".equals(sArg)) {
                    this.sTargetMIME = "text/html5";
                    continue;
                }
                if ("-xhtml".equals(sArg)) {
                    this.sTargetMIME = "text/html";
                    continue;
                }
                if ("-xhtml11".equals(sArg)) {
                    this.sTargetMIME = "application/xhtml11";
                    continue;
                }
                if ("-xhtml+mathml".equals(sArg)) {
                    this.sTargetMIME = "application/xhtml+xml";
                    continue;
                }
                if ("-epub".equals(sArg)) {
                    this.sTargetMIME = "application/epub+zip";
                    continue;
                }
                if ("-recurse".equals(sArg)) {
                    this.bRecurse = true;
                    continue;
                }
                if ("-ultraclean".equals(sArg)) {
                    this.configFileNames.add("*ultraclean.xml");
                    continue;
                }
                if ("-clean".equals(sArg)) {
                    this.configFileNames.add("*clean.xml");
                    continue;
                }
                if ("-pdfprint".equals(sArg)) {
                    this.configFileNames.add("*pdfprint.xml");
                    continue;
                }
                if ("-pdfscreen".equals(sArg)) {
                    this.configFileNames.add("*pdfscreen.xml");
                    continue;
                }
                if ("-cleanxhtml".equals(sArg)) {
                    this.configFileNames.add("*cleanxhtml.xml");
                    continue;
                }
                int j = sArg.indexOf("=");
                if (j > -1) {
                    sArg2 = sArg.substring(j + 1);
                    sArg = sArg.substring(0, j);
                } else {
                    sArg2 = this.getArg(i++, sArgs);
                }
                if ("-config".equals(sArg)) {
                    this.configFileNames.add(sArg2);
                    continue;
                }
                if ("-template".equals(sArg)) {
                    this.sTemplateFileName = sArg2;
                    continue;
                }
                if ("-stylesheet".equals(sArg)) {
                    this.sStyleSheetFileName = sArg2;
                    continue;
                }
                if ("-resource".equals(sArg)) {
                    this.resources.add(sArg2);
                    continue;
                }
                this.options.put(sArg.substring(1), sArg2);
                continue;
            }
            this.sSource = sArg;
            if (i < sArgs.length && (sArgument = this.getArg(i++, sArgs)).length() > 0) {
                this.sTarget = sArgument;
            }
            while (i < sArgs.length) {
                if ((sArgument = this.getArg(i++, sArgs)).length() <= 0) continue;
                throw new IllegalArgumentException("I didn't expect " + sArgument + "?");
            }
        }
        if (this.sSource == null) {
            throw new IllegalArgumentException("Please specify a source document/directory!");
        }
    }

    private String getArg(int i, String[] args) throws IllegalArgumentException {
        if (i < args.length) {
            return args[i];
        }
        throw new IllegalArgumentException("I'm sorry, the commandline ended abnormally");
    }
}

