/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.writer4latex;

import com.sun.star.uno.XComponentContext;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.openoffice.da.comp.writer4latex.ExternalApps;

public final class TeXify {
    public static final short GENERIC = 1;
    public static final short DVIPS = 2;
    public static final short PDFTEX = 3;
    public static final short XETEX = 4;
    private static final String[] genericTexify = new String[]{"LaTeX", "BibTeX", "Makeindex", "LaTeX", "Makeindex", "LaTeX"};
    private static final String[] pdfTexify = new String[]{"PdfLaTeX", "BibTeX", "Makeindex", "PdfLaTeX", "Makeindex", "PdfLaTeX"};
    private static final String[] dvipsTexify = new String[]{"LaTeX", "BibTeX", "Makeindex", "LaTeX", "Makeindex", "LaTeX", "Dvips"};
    private static final String[] xeTexify = new String[]{"XeLaTeX", "BibTeX", "Makeindex", "XeLaTeX", "Makeindex", "XeLaTeX"};
    private ExternalApps externalApps;

    public TeXify(XComponentContext xContext) {
        this.externalApps = new ExternalApps(xContext);
    }

    public boolean process(File file, String sBibinputs, short nBackend, boolean bView) throws IOException {
        if (file.getName().endsWith(".tex")) {
            file = new File(file.getParentFile(), file.getName().substring(0, file.getName().length() - 4));
        }
        this.externalApps.load();
        boolean bResult = false;
        if (nBackend == 1) {
            bResult = this.doTeXify(genericTexify, file, sBibinputs);
            if (!bResult) {
                return false;
            }
            if (this.externalApps.execute("DVIViewer", new File(file.getParentFile(), file.getName() + ".dvi").getPath(), file.getParentFile(), null, false) > 0) {
                throw new IOException("Error executing dvi viewer");
            }
        } else if (nBackend == 3) {
            bResult = this.doTeXify(pdfTexify, file, sBibinputs);
            if (!bResult) {
                return false;
            }
            if (this.externalApps.execute("PdfViewer", new File(file.getParentFile(), file.getName() + ".pdf").getPath(), file.getParentFile(), null, false) > 0) {
                throw new IOException("Error executing pdf viewer");
            }
        } else if (nBackend == 2) {
            bResult = this.doTeXify(dvipsTexify, file, sBibinputs);
            if (!bResult) {
                return false;
            }
            if (this.externalApps.execute("PostscriptViewer", new File(file.getParentFile(), file.getName() + ".ps").getPath(), file.getParentFile(), null, false) > 0) {
                throw new IOException("Error executing postscript viewer");
            }
        } else if (nBackend == 4) {
            bResult = this.doTeXify(xeTexify, file, sBibinputs);
            if (!bResult) {
                return false;
            }
            if (this.externalApps.execute("PdfViewer", new File(file.getParentFile(), file.getName() + ".pdf").getPath(), file.getParentFile(), null, false) > 0) {
                throw new IOException("Error executing pdf viewer");
            }
        }
        return bResult;
    }

    private boolean doTeXify(String[] sAppList, File file, String sBibinputs) throws IOException {
        File aux = new File(file.getParentFile(), file.getName() + ".aux");
        aux.delete();
        for (int i = 0; i < sAppList.length; ++i) {
            HashMap<String, String> env = null;
            if ("BibTeX".equals(sAppList[i]) && sBibinputs != null) {
                env = new HashMap<String, String>();
                env.put("BIBINPUTS", sBibinputs);
            }
            int nReturnCode = this.externalApps.execute(sAppList[i], file.getName(), file.getParentFile(), env, true);
            if (i != 0 || nReturnCode <= 0) continue;
            return false;
        }
        return true;
    }
}

