# is-dotfile [![NPM version](https://badge.fury.io/js/is-dotfile.svg)](http://badge.fury.io/js/is-dotfile)

> Return true if a file path is (or has) a dotfile. Returns false if the path is a dot directory.

## Install

Install with [npm](https://www.npmjs.com/)

```sh
$ npm i is-dotfile --save
```

## Usage

```js
var isDotfile = require('is-dotfile');
```

**false**

All of the following return `false`:

```js
isDotfile('a/b/c.js');
isDotfile('/.git/foo');
isDotfile('a/b/c/.git/foo');
//=> false
```

**true**

All of the following return `true`:

```js
isDotfile('a/b/.gitignore');
isDotfile('.gitignore');
isDotfile('/.gitignore');
//=> true
```

## Related projects

* [dotfile-regex](https://www.npmjs.com/package/dotfile-regex): Regular expresson for matching dotfiles. | [homepage](https://github.com/regexps/dotfile-regex)
* [has-glob](https://www.npmjs.com/package/has-glob): Returns `true` if an array has a glob pattern. | [homepage](https://github.com/jonschlinkert/has-glob)
* [is-dotdir](https://www.npmjs.com/package/is-dotdir): Returns true if a path is a dot-directory. | [homepage](https://github.com/jonschlinkert/is-dotdir)
* [is-glob](https://www.npmjs.com/package/is-glob): Returns `true` if the given string looks like a glob pattern or an extglob pattern.… [more](https://www.npmjs.com/package/is-glob) | [homepage](https://github.com/jonschlinkert/is-glob)

## Running tests

Install dev dependencies:

```sh
$ npm i -d && npm test
```

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/is-dotfile/issues/new).

## Authors

**Jon Schlinkert**

+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2015 Jon Schlinkert
Released under the MIT license.

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on October 20, 2015._